/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyList;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;

public class DocumentMarshaller
implements JsonMarshaller<Document> {
    @Override
    public String getType() {
        return "document";
    }

    @Override
    public Class<Document> getJavaType() {
        return Document.class;
    }

    @Override
    public String getReference(Document info) {
        return info.getInputRef();
    }

    @Override
    public Document read(JSONObject json) {
        return DocumentMarshaller.readDocument(json);
    }

    protected static Document readDocument(JSONObject json) {
        String uid = json.getString("uid");
        String path = json.getString("path");
        String type = json.getString("type");
        String state = json.optString("state", null);
        String lock = json.optString("lock", null);
        String title = json.optString("title", null);
        String lastModified = json.optString("lastModified", null);
        JSONObject jsonProps = json.optJSONObject("properties");
        PropertyMap props = jsonProps != null ? (PropertyMap)DocumentMarshaller.readValue(jsonProps) : new PropertyMap();
        props.set("dc:title", title);
        props.set("dc:modified", lastModified);
        return new Document(uid, type, path, state, lock, props);
    }

    @Override
    public void write(JSONObject object, Document doc) {
        throw new UnsupportedOperationException();
    }

    protected static Object readValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSON) {
            JSON jo = (JSON)o;
            if (jo == JSONNull.getInstance()) {
                return null;
            }
            if (jo.isArray()) {
                JSONArray ar = (JSONArray)jo;
                PropertyList plist = new PropertyList();
                List<Object> list = plist.list();
                int size = ar.size();
                for (int i = 0; i < size; ++i) {
                    Object v = DocumentMarshaller.readValue(ar.get(i));
                    if (v == null) continue;
                    list.add(v);
                }
                return plist;
            }
            JSONObject ob = (JSONObject)jo;
            if (ob.isNullObject()) {
                return null;
            }
            PropertyMap pmap = new PropertyMap();
            Map<String, Object> map = pmap.map();
            Iterator keys = ob.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object v = DocumentMarshaller.readValue(ob.get(key));
                map.put(key, v);
            }
            return pmap;
        }
        return o.toString();
    }
}

