/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.nuxeo.ecm.automation.client.adapters.DocumentServiceFactory;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpConnector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AsyncAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;

public class HttpAutomationClient
extends AsyncAutomationClient {
    protected HttpClient http;
    protected int httpConnectionTimeout;

    public HttpAutomationClient(String url) {
        this(url, 0);
    }

    public HttpAutomationClient(String url, int httpConnectionTimeout) {
        super(url);
        this.init(httpConnectionTimeout);
    }

    public HttpAutomationClient(String url, int httpConnectionTimeout, long asyncAwaitTerminationTimeout) {
        super(url, asyncAwaitTerminationTimeout);
        this.init(httpConnectionTimeout);
    }

    private void init(int httpConnectionTimeout) {
        this.http = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());
        this.httpConnectionTimeout = httpConnectionTimeout;
        this.registerAdapter(new DocumentServiceFactory());
    }

    public void setProxy(String host, int port) {
        this.http.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(host, port));
    }

    public HttpClient http() {
        return this.http;
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        this.http.getConnectionManager().shutdown();
        this.http = null;
    }

    @Override
    protected Connector newConnector() {
        return new HttpConnector(this.http, this.httpConnectionTimeout);
    }
}

