/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.nuxeo.ecm.automation.client.AdapterFactory;
import org.nuxeo.ecm.automation.client.AdapterManager;
import org.nuxeo.ecm.automation.client.AsyncCallback;
import org.nuxeo.ecm.automation.client.AutomationClient;
import org.nuxeo.ecm.automation.client.LoginCallback;
import org.nuxeo.ecm.automation.client.LoginInfo;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JavaSession;

public abstract class JavaClient
implements AutomationClient {
    protected String url;
    protected AdapterManager adapters;
    protected ExecutorService async;

    protected JavaClient(String url) {
        this(url, null);
    }

    public JavaClient(String url, ExecutorService executor) {
        this.url = url.endsWith("/") ? url : url + "/";
        this.async = executor == null ? Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread("AutomationAsyncExecutor");
            }
        }) : executor;
    }

    protected abstract LoginInfo login(String var1, String var2);

    protected abstract JavaSession createSession(LoginInfo var1);

    @Override
    public String getBaseUrl() {
        return this.url;
    }

    public AdapterManager getAdapterManager() {
        return this.adapters;
    }

    public void asyncExec(Runnable runnable) {
        this.async.execute(runnable);
    }

    @Override
    public <T> T getAdapter(Session session, Class<T> adapterType) {
        return this.adapters.getAdapter(session, adapterType);
    }

    @Override
    public void registerAdapter(AdapterFactory<?> factory) {
        this.adapters.registerAdapter(factory);
    }

    @Override
    public void getSession(final LoginCallback loginCb, final AsyncCallback<Session> cb) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session session = JavaClient.this.getSession(loginCb);
                    cb.onSuccess(session);
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public void getSession(final AsyncCallback<Session> cb) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session session = JavaClient.this.getSession();
                    cb.onSuccess(session);
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public void getSession(final String username, final String password, final AsyncCallback<Session> cb) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session session = JavaClient.this.getSession(username, password);
                    cb.onSuccess(session);
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public Session getSession(LoginCallback cb) {
        String[] login = cb.getLogin();
        return this.getSession(login[0], login[1]);
    }

    @Override
    public Session getSession(String username, String password) {
        LoginInfo login = this.login(username, password);
        if (login == null) {
            throw new RuntimeException("Failed to login as " + username);
        }
        return this.createSession(login);
    }

    @Override
    public Session getSession() {
        return this.getSession((String)null, (String)null);
    }

    @Override
    public void shutdown() {
        this.shutdown(500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(long timeout) {
        try {
            this.async.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.async = null;
            this.url = null;
            this.adapters = null;
        }
    }
}

