/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.codec.Charsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.impl.MultipartRequestEntity;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;

public class HttpConnector
implements Connector {
    protected final HttpClient http;
    protected final int httpConnectionTimeout;
    protected final HttpContext ctx;
    protected String basicAuth;

    public HttpConnector(HttpClient http) {
        this(http, 0);
    }

    public HttpConnector(HttpClient http, int httpConnectionTimeout) {
        this(http, (HttpContext)new BasicHttpContext(), httpConnectionTimeout);
    }

    public HttpConnector(HttpClient http, HttpContext ctx) {
        this(http, ctx, 0);
    }

    public HttpConnector(HttpClient http, HttpContext ctx, int httpConnectionTimeout) {
        ctx.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
        this.http = http;
        this.httpConnectionTimeout = httpConnectionTimeout;
        this.ctx = ctx;
    }

    @Override
    public Object execute(Request request) {
        HttpGet httpRequest = null;
        if (request.getMethod() == 1) {
            HttpPost post = new HttpPost(request.getUrl());
            Object obj = request.getEntity();
            if (obj != null) {
                MultipartRequestEntity entity = null;
                if (request.isMultiPart()) {
                    entity = new MultipartRequestEntity((MimeMultipart)obj);
                } else {
                    try {
                        entity = new StringEntity(obj.toString(), Charsets.UTF_8);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw new Error("Cannot encode into UTF-8", e);
                    }
                }
                post.setEntity((HttpEntity)entity);
            }
            httpRequest = post;
        } else {
            httpRequest = new HttpGet(request.getUrl());
        }
        try {
            return this.execute(request, (HttpUriRequest)httpRequest);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot execute " + request, e);
        }
    }

    protected Object execute(Request request, HttpUriRequest httpReq) throws Exception {
        for (Map.Entry entry : request.entrySet()) {
            httpReq.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        HttpResponse resp = this.executeRequestWithTimeout(httpReq);
        HttpEntity entity = resp.getEntity();
        int status = resp.getStatusLine().getStatusCode();
        if (entity == null) {
            if (status < 400) {
                return null;
            }
            throw new RemoteException(status, "ServerError", "Server Error", (Throwable)null);
        }
        Header ctypeHeader = entity.getContentType();
        if (ctypeHeader == null) {
            if (status != 200) {
                throw new RemoteException(status, "ServerError", "Server Error", (Throwable)null);
            }
            return null;
        }
        String ctype = ctypeHeader.getValue();
        String disp = null;
        Header[] hdisp = resp.getHeaders("Content-Disposition");
        if (hdisp != null && hdisp.length > 0) {
            disp = hdisp[0].getValue();
        }
        return request.handleResult(status, ctype, disp, entity.getContent());
    }

    protected HttpResponse executeRequestWithTimeout(HttpUriRequest httpReq) throws Exception {
        if (this.httpConnectionTimeout > 0) {
            HttpParams httpParams = this.http.getParams();
            httpParams.setIntParameter("http.socket.timeout", this.httpConnectionTimeout);
            httpParams.setIntParameter("http.connection-manager.timeout", this.httpConnectionTimeout);
            httpParams.setIntParameter("http.connection.timeout", this.httpConnectionTimeout);
        }
        return this.http.execute(httpReq, this.ctx);
    }
}

