/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializationProblemHandler;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonCachable;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializerModifier;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.type.TypeBindings;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.type.TypeModifier;
import org.codehaus.jackson.type.JavaType;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.RemoteThrowable;
import org.nuxeo.ecm.automation.client.jaxrs.impl.AutomationClientActivator;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.BooleanMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.DateMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.DocumentMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.DocumentsMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.ExceptionMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.LoginMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.NumberMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.RecordSetMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.StringMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.util.JsonOperationMarshaller;
import org.nuxeo.ecm.automation.client.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.OperationRegistry;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class JsonMarshalling {
    protected static final Log log = LogFactory.getLog(JsonMarshalling.class);
    protected static JsonFactory factory = JsonMarshalling.newJsonFactory();
    protected static final Map<String, JsonMarshaller<?>> marshallersByType = new ConcurrentHashMap();
    protected static final Map<Class<?>, JsonMarshaller<?>> marshallersByJavaType = new ConcurrentHashMap();

    private JsonMarshalling() {
    }

    public static JsonFactory getFactory() {
        return factory;
    }

    public static JsonFactory newJsonFactory() {
        JsonFactory jf = new JsonFactory();
        ObjectMapper oc = new ObjectMapper(jf);
        TypeFactory typeFactoryWithModifier = oc.getTypeFactory().withModifier((TypeModifier)new ThowrableTypeModifier());
        oc.setTypeFactory(typeFactoryWithModifier);
        oc.getDeserializationConfig().addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
                if (deserializer instanceof ThrowableDeserializer) {
                    JsonParser jp = ctxt.getParser();
                    JsonNode propertyNode = jp.readValueAsTree();
                    ((ThrowableDeserializer)deserializer).otherNodes.put(propertyName, propertyNode);
                    return true;
                }
                return false;
            }
        });
        SimpleModule module = new SimpleModule("automation", Version.unknownVersion()){

            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanDeserializerModifier(new BeanDeserializerModifier(){

                    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BasicBeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                        if (!Throwable.class.isAssignableFrom(beanDesc.getBeanClass())) {
                            return super.modifyDeserializer(config, beanDesc, deserializer);
                        }
                        return new ThrowableDeserializer((BeanDeserializer)deserializer);
                    }
                });
            }
        };
        oc.registerModule((Module)module);
        jf.setCodec((ObjectCodec)oc);
        return jf;
    }

    public static void addMarshaller(JsonMarshaller<?> marshaller) {
        marshallersByType.put(marshaller.getType(), marshaller);
        marshallersByJavaType.put(marshaller.getJavaType(), marshaller);
    }

    public static <T> JsonMarshaller<T> getMarshaller(String type) {
        return marshallersByType.get(type);
    }

    public static <T> JsonMarshaller<T> getMarshaller(Class<T> clazz) {
        return marshallersByJavaType.get(clazz);
    }

    public static OperationRegistry readRegistry(String content) throws IOException {
        HashMap<String, OperationDocumentation> ops = new HashMap<String, OperationDocumentation>();
        HashMap<String, OperationDocumentation> chains = new HashMap<String, OperationDocumentation>();
        HashMap<String, String> paths = new HashMap<String, String>();
        JsonParser jp = factory.createJsonParser(content);
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        while (tok != null && tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            if ("operations".equals(key)) {
                JsonMarshalling.readOperations(jp, ops);
            } else if ("chains".equals(key)) {
                JsonMarshalling.readChains(jp, chains);
            } else if ("paths".equals(key)) {
                JsonMarshalling.readPaths(jp, paths);
            }
            tok = jp.nextToken();
        }
        if (tok == null) {
            throw new IllegalArgumentException("Unexpected end of stream.");
        }
        return new OperationRegistry(paths, ops, chains);
    }

    private static void readOperations(JsonParser jp, Map<String, OperationDocumentation> ops) throws IOException {
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        while (tok != null && tok != JsonToken.END_ARRAY) {
            OperationDocumentation op = JsonOperationMarshaller.read(jp);
            ops.put(op.id, op);
            if (op.aliases != null) {
                for (String alias : op.aliases) {
                    ops.put(alias, op);
                }
            }
            tok = jp.nextToken();
        }
    }

    private static void readChains(JsonParser jp, Map<String, OperationDocumentation> chains) throws IOException {
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        while (tok != null && tok != JsonToken.END_ARRAY) {
            OperationDocumentation op = JsonOperationMarshaller.read(jp);
            chains.put(op.id, op);
            tok = jp.nextToken();
        }
    }

    private static void readPaths(JsonParser jp, Map<String, String> paths) throws IOException {
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        while (tok != null && tok != JsonToken.END_OBJECT) {
            jp.nextToken();
            paths.put(jp.getCurrentName(), jp.getText());
            tok = jp.nextToken();
        }
        if (tok == null) {
            throw new IllegalArgumentException("Unexpected end of stream.");
        }
    }

    public static Object readEntity(String content) throws IOException {
        if (content.length() == 0) {
            return null;
        }
        JsonParser jp = factory.createJsonParser(content);
        jp.nextToken();
        jp.nextToken();
        if (!"entity-type".equals(jp.getText())) {
            throw new RuntimeException("unuspported respone type. No entity-type key found at top of the object");
        }
        jp.nextToken();
        String etype = jp.getText();
        JsonMarshaller jm = JsonMarshalling.getMarshaller(etype);
        if (jm == null) {
            try {
                AutomationClientActivator automationClientActivator = AutomationClientActivator.getInstance();
                Class loadClass = automationClientActivator == null ? Thread.currentThread().getContextClassLoader().loadClass(etype) : automationClientActivator.getContext().getBundle().loadClass(etype);
                ObjectMapper mapper = new ObjectMapper();
                jp.nextToken();
                jp.nextToken();
                jp.nextToken();
                return mapper.readValue(jp, loadClass);
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("No marshaller for " + etype + " and not a valid Java class name either."));
                jp = factory.createJsonParser(content);
                return jp.readValueAsTree();
            }
        }
        return jm.read(jp);
    }

    public static String writeRequest(OperationRequest req) throws IOException {
        StringWriter writer = new StringWriter();
        Object input = req.getInput();
        JsonGenerator jg = factory.createJsonGenerator((Writer)writer);
        jg.writeStartObject();
        if (input instanceof OperationInput) {
            OperationInput operationInput = (OperationInput)input;
            String ref = operationInput.getInputRef();
            if (ref != null) {
                jg.writeStringField("input", ref);
            }
        } else if (input != null) {
            JsonMarshaller<?> marshaller = JsonMarshalling.getMarshaller(input.getClass());
            if (marshaller != null) {
                jg.writeFieldName("input");
                marshaller.write(jg, input);
            } else {
                jg.writeObjectField("input", input);
            }
        }
        jg.writeObjectFieldStart("params");
        JsonMarshalling.writeMap(jg, req.getParameters());
        jg.writeEndObject();
        jg.writeObjectFieldStart("context");
        JsonMarshalling.writeMap(jg, req.getContextParameters());
        jg.writeEndObject();
        jg.writeEndObject();
        jg.close();
        return writer.toString();
    }

    public static void writeMap(JsonGenerator jg, Map<String, Object> map) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof String) {
                jg.writeStringField(entry.getKey(), (String)obj);
                continue;
            }
            if (obj instanceof PropertyMap || obj instanceof OperationInput) {
                jg.writeStringField(entry.getKey(), obj.toString());
                continue;
            }
            jg.writeFieldName(entry.getKey());
            jg.writeObject(obj);
        }
    }

    static {
        JsonMarshalling.addMarshaller(new DocumentMarshaller());
        JsonMarshalling.addMarshaller(new DocumentsMarshaller());
        JsonMarshalling.addMarshaller(new ExceptionMarshaller());
        JsonMarshalling.addMarshaller(new LoginMarshaller());
        JsonMarshalling.addMarshaller(new RecordSetMarshaller());
        JsonMarshalling.addMarshaller(new StringMarshaller());
        JsonMarshalling.addMarshaller(new BooleanMarshaller());
        JsonMarshalling.addMarshaller(new NumberMarshaller());
        JsonMarshalling.addMarshaller(new DateMarshaller());
    }

    @JsonCachable(value=false)
    public static class ThrowableDeserializer
    extends org.codehaus.jackson.map.deser.ThrowableDeserializer {
        protected HashMap<String, JsonNode> otherNodes = new HashMap();

        public ThrowableDeserializer(BeanDeserializer src) {
            super(src);
        }

        public Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            RemoteThrowable t = (RemoteThrowable)super.deserializeFromObject(jp, ctxt);
            t.getOtherNodes().putAll(this.otherNodes);
            return t;
        }
    }

    public static class ThowrableTypeModifier
    extends TypeModifier {
        public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
            Class raw = type.getRawClass();
            if (raw.equals(Throwable.class)) {
                return typeFactory.constructType(RemoteThrowable.class);
            }
            return type;
        }
    }
}

