/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.ExceptionMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.util.IOUtils;
import org.nuxeo.ecm.automation.client.jaxrs.util.InputStreamDataSource;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.FileBlob;

public class Request
extends HashMap<String, String> {
    public static final int GET = 0;
    public static final int POST = 1;
    private static final long serialVersionUID = 1L;
    protected static Pattern ATTR_PATTERN = Pattern.compile(";?\\s*filename\\s*=\\s*([^;]+)\\s*", 2);
    protected final int method;
    protected final String url;
    protected final boolean isMultiPart;
    protected Object entity;

    public Request(int method, String url) {
        this.method = method;
        this.url = url;
        this.isMultiPart = false;
    }

    public Request(int method, String url, MimeMultipart entity) {
        this.method = method;
        this.url = url;
        this.entity = entity;
        this.isMultiPart = true;
    }

    public Request(int method, String url, String entity) {
        this.method = method;
        this.url = url;
        this.entity = entity;
        this.isMultiPart = false;
    }

    public int getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Object getEntity() {
        return this.entity;
    }

    public final boolean isMultiPart() {
        return this.isMultiPart;
    }

    public MimeMultipart asMultiPartEntity() {
        return this.isMultiPart ? (MimeMultipart)this.entity : null;
    }

    public String asStringEntity() {
        return this.isMultiPart ? null : (String)this.entity;
    }

    public Object handleResult(int status, String ctype, String disp, InputStream stream) throws RemoteException, IOException {
        String lctype;
        if (status == 204) {
            return null;
        }
        if (status >= 400) {
            this.handleException(status, ctype, stream);
        }
        if ((lctype = ctype.toLowerCase()).startsWith("application/json+nxentity")) {
            return JsonMarshalling.readEntity(IOUtils.read(stream));
        }
        if (lctype.startsWith("application/json+nxautomation")) {
            return JsonMarshalling.readRegistry(IOUtils.read(stream));
        }
        if (lctype.startsWith("multipart/mixed")) {
            return Request.readBlobs(ctype, stream);
        }
        String fname = null;
        if (disp != null) {
            fname = Request.getFileName(disp);
        }
        return Request.readBlob(ctype, fname, stream);
    }

    protected static Blobs readBlobs(String ctype, InputStream in) throws IOException {
        Blobs files = new Blobs();
        File file = IOUtils.copyToTempFile(in);
        FileInputStream fin = new FileInputStream(file);
        try {
            MimeMultipart mp = new MimeMultipart((DataSource)new InputStreamDataSource(fin, ctype));
            int size = mp.getCount();
            for (int i = 0; i < size; ++i) {
                BodyPart part = mp.getBodyPart(i);
                String fname = part.getFileName();
                files.add(Request.readBlob(part.getContentType(), fname, part.getInputStream()));
            }
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        finally {
            try {
                fin.close();
            }
            catch (IOException e) {}
            file.delete();
        }
        return files;
    }

    protected static Blob readBlob(String ctype, String fileName, InputStream in) throws IOException {
        File file = IOUtils.copyToTempFile(in);
        file.deleteOnExit();
        FileBlob blob = new FileBlob(file);
        blob.setMimeType(ctype);
        if (fileName != null) {
            blob.setFileName(fileName);
        }
        return blob;
    }

    protected static String getFileName(String ctype) {
        Matcher m = ATTR_PATTERN.matcher(ctype);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected void handleException(int status, String ctype, InputStream stream) throws RemoteException, IOException {
        if ("application/json+nxentity".equalsIgnoreCase(ctype)) {
            String content = IOUtils.read(stream);
            RemoteException e = null;
            try {
                e = ExceptionMarshaller.readException(content);
            }
            catch (IOException t) {
                throw new RemoteException(status, "ServerError", "Server Error", content);
            }
            throw e;
        }
        throw new RemoteException(status, "ServerError", "Server Error", IOUtils.read(stream));
    }
}

