/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.nuxeo.ecm.automation.client.annotations.EntityType;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;

public class PojoMarshaller<T>
implements JsonMarshaller<T> {
    final Class<T> type;
    protected String entityTypeName;

    public PojoMarshaller(Class<T> type) {
        this.type = type;
        this.entityTypeName = "";
        if (type.getAnnotation(EntityType.class) != null) {
            this.entityTypeName = type.getAnnotation(EntityType.class).value();
        }
    }

    public static <T> PojoMarshaller<T> forClass(Class<T> type) {
        return new PojoMarshaller<T>(type);
    }

    @Override
    public String getType() {
        return this.entityTypeName.isEmpty() ? this.type.getName() : this.entityTypeName;
    }

    @Override
    public Class<T> getJavaType() {
        return this.type;
    }

    @Override
    public T read(JsonParser jp) throws IOException {
        jp.nextToken();
        jp.nextToken();
        return (T)jp.readValueAs(this.type);
    }

    @Override
    public void write(JsonGenerator jg, Object value) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", this.getType());
        jg.writeObjectField("value", value);
        jg.writeEndObject();
    }
}

