/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public class IOUtils {
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MIN_BUFFER_SIZE = 8192;

    private IOUtils() {
    }

    private static byte[] createBuffer(int preferredSize) {
        if (preferredSize < 1) {
            preferredSize = 65536;
        }
        if (preferredSize > 0x100000) {
            preferredSize = 0x100000;
        } else if (preferredSize < 8192) {
            preferredSize = 8192;
        }
        return new byte[preferredSize];
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = IOUtils.createBuffer(in.available());
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static File copyToTempFile(InputStream in) throws IOException {
        File file = File.createTempFile("nxautomation-", ".tmp", new File(System.getProperty("java.io.tmpdir")));
        file.deleteOnExit();
        IOUtils.copyToFile(in, file, true);
        return file;
    }

    public static File copyToTempFile(InputStream in, boolean closeIn) throws IOException {
        File file = File.createTempFile("nxautomation-", ".tmp", new File(System.getProperty("java.io.tmpdir")));
        file.deleteOnExit();
        IOUtils.copyToFile(in, file, closeIn);
        return file;
    }

    public static void copyToFile(InputStream in, File file) throws IOException {
        IOUtils.copyToFile(in, file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFile(InputStream in, File file, boolean closeIn) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            IOUtils.copy(in, out);
        }
        finally {
            out.close();
            if (closeIn) {
                in.close();
            }
        }
    }

    public static void writeToFile(String content, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            IOUtils.write(content, out);
        }
    }

    public static void write(String content, OutputStream out) throws IOException {
        out.write(content.getBytes());
    }

    public static String read(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        return IOUtils.read(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader in) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            int read;
            char[] buffer = new char[65536];
            while ((read = in.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, read));
            }
        }
        finally {
            in.close();
        }
        return sb.toString();
    }
}

