/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.collections;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.collections.api.FavoritesManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

@Operation(id="Document.AddToFavorites", category="Document", label="Add document to favorites", description="Add a list of documents in the favorites. No value is returned.", aliases={"Collection.AddToFavorites"})
public class AddToFavoritesOperation {
    public static final String ID = "Document.AddToFavorites";
    @Context
    protected CoreSession session;
    @Context
    protected FavoritesManager favoritesManager;

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        for (DocumentModel doc : docs) {
            this.favoritesManager.addToFavorites(doc, this.session);
        }
        return docs;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        this.favoritesManager.addToFavorites(doc, this.session);
        return doc;
    }
}

