/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.PageProviderHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;

@Operation(id="Repository.PageProvider", category="Fetch", label="PageProvider", description="Perform a named provider query on the repository. Result is paginated. The query result will become the input for the next operation.", aliases={"Document.PageProvider"})
public class DocumentPageProviderOperation {
    public static final String ID = "Repository.PageProvider";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Param(name="providerName", required=true)
    protected String providerName;
    @Param(name="language", required=false, widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="currentPageIndex", alias={"page"}, required=false)
    protected Integer currentPageIndex;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Param(name="queryParams", alias={"searchTerm"}, required=false)
    protected StringList strParameters;
    @Param(name="documentLinkBuilder", required=false)
    protected String documentLinkBuilder;
    @Param(name="namedParameters", required=false, description="Named parameters to pass to the page provider to fill in query variables.")
    protected Properties namedParameters;
    @Param(name="sortBy", required=false, description="Sort by properties (separated by comma)")
    protected StringList sortBy;
    @Param(name="sortOrder", required=false, description="Sort order, ASC or DESC", widget="Option", values={"ASC", "DESC"})
    protected StringList sortOrder;
    @Param(name="quickFilters", required=false, description="Quick filter properties (separated by comma)")
    protected StringList quickFilters;
    @Param(name="highlights", required=false, description="Highlight properties (separated by comma)")
    protected StringList highlights;

    @OperationMethod
    public PaginableDocumentModelListImpl run() throws OperationException {
        PageProvider pp;
        PaginableDocumentModelListImpl res;
        PageProviderDefinition def = PageProviderHelper.getPageProviderDefinition((String)this.providerName);
        Long targetPage = this.currentPageIndex != null ? Long.valueOf(this.currentPageIndex.longValue()) : null;
        Long targetPageSize = this.pageSize != null ? Long.valueOf(this.pageSize.longValue()) : null;
        Object[] parameters = this.strParameters != null ? this.strParameters.toArray((Object[])new String[0]) : null;
        ActionContext actionContext = (ActionContext)this.context.get((Object)"seamActionContext");
        if (actionContext != null) {
            parameters = PageProviderHelper.resolveELParameters((PageProviderDefinition)def, (Object[])parameters);
        }
        if ((res = new PaginableDocumentModelListImpl(pp = PageProviderHelper.getPageProvider((CoreSession)this.session, (PageProviderDefinition)def, (Map)this.namedParameters, (List)this.sortBy, (List)this.sortOrder, (Long)targetPageSize, (Long)targetPage, (List)this.highlights, (List)this.quickFilters, (Object[])parameters), this.documentLinkBuilder)).hasError()) {
            throw new OperationException(res.getErrorMessage());
        }
        return res;
    }
}

