/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

@Operation(id="BlobHolder.AttachOnCurrentDocument", category="Files", label="Attach File or files to the currentDocument.", description="Attach the input file(s) to the current document using the BlobHolder abstraction", aliases={"BlobHolder.Attach"})
public class BlobHolderAttach {
    public static final String ID = "BlobHolder.AttachOnCurrentDocument";
    @Context
    protected CoreSession session;
    @Context
    protected AutomationService as;
    @Context
    protected OperationContext context;
    @Param(name="useMainBlob", required=false)
    protected boolean useMainBlob = true;

    protected DocumentModel getCurrentDocument() throws OperationException {
        String cdRef = (String)this.context.get((Object)"currentDocument");
        return (DocumentModel)this.as.getAdaptedValue(this.context, (Object)cdRef, DocumentModel.class);
    }

    @OperationMethod
    public DocumentModel run(Blob blob) throws OperationException {
        DocumentModel currentDocument = this.getCurrentDocument();
        BlobHolder bh = (BlobHolder)currentDocument.getAdapter(BlobHolder.class);
        if (bh == null) {
            return currentDocument;
        }
        bh.setBlob(blob);
        currentDocument = this.session.saveDocument(currentDocument);
        this.context.put("currentDocument", (Object)currentDocument);
        return currentDocument;
    }

    @OperationMethod
    public DocumentModel run(BlobList blobs) throws OperationException {
        DocumentModel currentDocument;
        if (this.useMainBlob) {
            Blob mainBlob = (Blob)blobs.remove(0);
            currentDocument = this.run(mainBlob);
        } else {
            currentDocument = this.getCurrentDocument();
        }
        if (blobs.size() > 0 && currentDocument.hasSchema("files")) {
            ArrayList existingBlobs = (ArrayList)currentDocument.getPropertyValue("files:files");
            if (existingBlobs == null) {
                existingBlobs = new ArrayList();
            }
            for (Blob blob : blobs) {
                HashMap<String, Blob> map = new HashMap<String, Blob>();
                map.put("file", blob);
                existingBlobs.add(map);
            }
            currentDocument.setPropertyValue("files:files", (Serializable)existingBlobs);
            currentDocument = this.session.saveDocument(currentDocument);
        }
        return currentDocument;
    }
}

