/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.PaginableRecordSetImpl;
import org.nuxeo.ecm.automation.core.util.PageProviderHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.RecordSet;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;

@Operation(id="Repository.ResultSetPageProvider", category="Fetch", label="QueryAndFetch", description="Perform a named provider query on the repository. Result is paginated.The result is returned as a RecordSet (QueryAndFetch) rather than as a List of DocumentThe query result will become the input for the next operation.", addToStudio=false, aliases={"Resultset.PageProvider"})
public class ResultSetPageProviderOperation {
    public static final String ID = "Repository.ResultSetPageProvider";
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";
    public static final String CMIS = "CMIS";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Param(name="language", required=false, widget="Option", values={"NXQL", "CMIS"})
    protected String lang = "NXQL";
    @Param(name="currentPageIndex", alias={"page"}, required=false)
    protected Integer page;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Param(name="queryParams", required=false)
    protected StringList strParameters;
    @Param(name="maxResults", required=false)
    protected String maxResults = "100";
    @Param(name="namedParameters", required=false, description="Named parameters to pass to the page provider to fill in query variables.")
    protected Properties namedParameters;
    @Param(name="sortBy", required=false, description="Sort by properties (separated by comma)")
    protected StringList sortBy;
    @Param(name="sortOrder", required=false, description="Sort order, ASC or DESC", widget="Option", values={"ASC", "DESC"})
    protected StringList sortOrder;

    @OperationMethod
    public RecordSet run() throws OperationException {
        Long targetPage;
        Long targetPageSize;
        PageProviderDefinition def = PageProviderHelper.getPageProviderDefinition((String)this.providerName);
        PageProvider pp = PageProviderHelper.getPageProvider((CoreSession)this.session, (PageProviderDefinition)def, (Map)this.namedParameters, (List)this.sortBy, (List)this.sortOrder, (Long)(targetPageSize = this.pageSize != null ? Long.valueOf(this.pageSize.longValue()) : null), (Long)(targetPage = this.page != null ? Long.valueOf(this.page.longValue()) : null), this.strParameters != null ? this.strParameters.toArray((Object[])new String[0]) : null);
        PaginableRecordSetImpl res = new PaginableRecordSetImpl((PageProvider<Map<String, Serializable>>)pp);
        if (res.hasError()) {
            throw new OperationException(res.getErrorMessage());
        }
        return res;
    }
}

