/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;

@Operation(id="Picture.Create", category="Services", label="Create Picture", description="Create a Picture document in the input folder. You can initialize the document properties using the 'properties' parameter. The properties are specified as <i>key=value</i> pairs separated by a new line. The key <i>originalPicture</i> is used to reference the JSON representation of the Blob for the original picture. The <i>pictureTemplates</i> parameter can be used to define the size of the different views to be generated, each line must be a JSONObject { title=\"title\", description=\"description\", maxsize=maxsize}. Returns the created document.")
public class CreatePicture {
    public static final String ID = "Picture.Create";
    public static final String PICTURE_FIELD = "originalPicture";
    @Context
    protected CoreSession session;
    @Param(name="name", required=false)
    protected String name;
    @Param(name="properties", required=false)
    protected Properties content;
    @Param(name="pictureTemplates", required=false)
    protected Properties pictureTemplates;
    protected static final Log log = LogFactory.getLog(CreatePicture.class);

    protected ArrayList<Map<String, Object>> computePictureTemplates() {
        if (this.pictureTemplates == null || this.pictureTemplates.size() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> templates = new ArrayList<Map<String, Object>>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            for (String name : this.pictureTemplates.keySet()) {
                String templateDef = (String)this.pictureTemplates.get((Object)name);
                JsonNode node = mapper.readTree(templateDef);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("tag", name);
                Iterator it = node.getFields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    if (((JsonNode)entry.getValue()).isInt() || ((JsonNode)entry.getValue()).isLong()) {
                        map.put((String)entry.getKey(), ((JsonNode)entry.getValue()).getLongValue());
                        continue;
                    }
                    map.put((String)entry.getKey(), ((JsonNode)entry.getValue()).getValueAsText());
                }
                templates.add(map);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while parsing picture templates", (Throwable)e);
        }
        return templates;
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (this.name == null) {
            this.name = "Untitled";
        }
        String jsonBlob = (String)this.content.get((Object)PICTURE_FIELD);
        this.content.remove((Object)PICTURE_FIELD);
        ArrayList<Map<String, Object>> templates = this.computePictureTemplates();
        DocumentModel newDoc = this.session.createDocumentModel(doc.getPathAsString(), this.name, "Picture");
        if (this.content != null) {
            DocumentHelper.setProperties((CoreSession)this.session, (DocumentModel)newDoc, (Map)this.content);
        }
        DocumentModel picture = this.session.createDocument(newDoc);
        if (jsonBlob == null) {
            log.warn((Object)"Properties does not contains originalPicture field");
        } else {
            Blob blob = (Blob)ComplexTypeJSONDecoder.decode(null, (String)jsonBlob);
            if (blob == null) {
                log.warn((Object)"Unable to read Blob from properties");
            } else {
                PictureResourceAdapter adapter = (PictureResourceAdapter)picture.getAdapter(PictureResourceAdapter.class);
                adapter.createPicture(blob, blob.getFilename(), picture.getTitle(), templates);
                picture = this.session.saveDocument(picture);
            }
        }
        return picture;
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef doc) throws Exception {
        return this.run(this.session.getDocument(doc));
    }
}

