/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.PaginableRecordSetImpl;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.RecordSet;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryAndFetchPageProvider;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Resultset.PageProvider", category="Fetch", label="QueryAndFetch", description="Perform a query or a named provider query on the repository. Result is paginated. The result is returned as a RecordSet (QueryAndFetch) rather than as a List of DocumentThe query result will become the input for the next operation. If no query or provider name is given, a query returning all the documents that the user has access to will be executed.", addToStudio=false)
public class ResultSetPageProviderOperation {
    public static final String ID = "Resultset.PageProvider";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";
    public static final String CMIS = "CMIS";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Param(name="query", required=false)
    protected String query;
    @Param(name="language", required=false, widget="Option", values={"NXQL", "CMIS"})
    protected String lang = "NXQL";
    @Param(name="page", required=false)
    protected Integer page;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Deprecated
    @Param(name="sortInfo", required=false)
    protected StringList sortInfoAsStringList;
    @Param(name="queryParams", required=false)
    protected StringList strParameters;
    @Param(name="documentLinkBuilder", required=false)
    protected String documentLinkBuilder;
    @Param(name="maxResults", required=false)
    protected String maxResults = "100";
    @Param(name="namedParameters", required=false, description="Named parameters to pass to the page provider to fill in query variables.")
    protected Properties namedParameters;
    @Param(name="sortBy", required=false, description="Sort by properties (separated by comma)")
    protected String sortBy;
    @Param(name="sortOrder", required=false, description="Sort order, ASC or DESC", widget="Option", values={"ASC", "DESC"})
    protected String sortOrder;

    @OperationMethod
    public RecordSet run() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        ArrayList<SortInfo> sortInfos = null;
        if (this.sortInfoAsStringList != null) {
            sortInfos = new ArrayList<SortInfo>();
            for (String sortInfoDesc : this.sortInfoAsStringList) {
                SortInfo sortInfo;
                if (sortInfoDesc.contains("|")) {
                    String[] parts = sortInfoDesc.split("|");
                    sortInfo = new SortInfo(parts[0], Boolean.parseBoolean(parts[1]));
                } else {
                    sortInfo = new SortInfo(sortInfoDesc, true);
                }
                sortInfos.add(sortInfo);
            }
        } else if (!StringUtils.isBlank((String)this.sortBy)) {
            sortInfos = new ArrayList();
            String[] sorts = this.sortBy.split(",");
            String[] orders = null;
            if (!StringUtils.isBlank((String)this.sortOrder)) {
                orders = this.sortOrder.split(",");
            }
            for (int i = 0; i < sorts.length; ++i) {
                String sort = sorts[i];
                boolean sortAscending = orders != null && orders.length > i && "asc".equals(orders[i].toLowerCase());
                sortInfos.add(new SortInfo(sort, sortAscending));
            }
        }
        Object[] parameters = null;
        if (this.strParameters != null && !this.strParameters.isEmpty()) {
            parameters = this.strParameters.toArray((Object[])new String[this.strParameters.size()]);
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = (String)parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = this.session.getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = this.session.getRepositoryName();
            }
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        if (this.query == null && (this.providerName == null || this.providerName.length() == 0)) {
            this.query = "SELECT * from Document";
        }
        Long targetPage = null;
        if (this.page != null) {
            targetPage = this.page.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        SimpleDocumentModel searchDocumentModel = null;
        if (this.namedParameters != null && !this.namedParameters.isEmpty()) {
            searchDocumentModel = new SimpleDocumentModel();
            searchDocumentModel.putContextData("namedParameters", (Serializable)this.namedParameters);
        }
        PageProvider pp = null;
        if (this.query != null) {
            final class QueryAndFetchProviderDescriptor
            extends GenericPageProviderDescriptor {
                private static final long serialVersionUID = 1L;

                public QueryAndFetchProviderDescriptor() {
                    try {
                        this.klass = Class.forName(CoreQueryAndFetchPageProvider.class.getName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            QueryAndFetchProviderDescriptor desc = new QueryAndFetchProviderDescriptor();
            desc.setPattern(this.query);
            if (this.maxResults != null && !this.maxResults.isEmpty() && !this.maxResults.equals("-1")) {
                desc.getProperties().put("maxResults", this.maxResults);
            }
            pp = (CoreQueryAndFetchPageProvider)pps.getPageProvider("", (PageProviderDefinition)desc, (DocumentModel)searchDocumentModel, sortInfos, targetPageSize, targetPage, props, parameters);
        } else {
            pp = pps.getPageProvider(this.providerName, (DocumentModel)searchDocumentModel, sortInfos, targetPageSize, targetPage, props, parameters);
        }
        return new PaginableRecordSetImpl((PageProvider<Map<String, Serializable>>)pp);
    }
}

