/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.internet.SharedInputStream;

public class SharedFileInputStream
extends InputStream
implements SharedInputStream {
    protected final InputStream in;
    protected final SharedFileInputStream parent;
    protected final File file;
    protected final long length;
    protected final long start;
    protected long current;
    protected long marked;

    public SharedFileInputStream(File file) throws IOException {
        this.in = new BufferedInputStream(new FileInputStream(file));
        this.parent = null;
        this.file = file;
        this.start = 0L;
        this.length = file.length();
    }

    protected SharedFileInputStream(SharedFileInputStream parent, long start, long len) throws IOException {
        this.in = new BufferedInputStream(new FileInputStream(parent.file));
        this.parent = parent;
        this.file = parent.file;
        this.start = start;
        this.length = len;
        SharedFileInputStream.skip(this.in, start);
    }

    protected static void skip(InputStream in, long n) throws IOException {
        long skipped;
        for (long todo = n; todo > 0L; todo -= skipped) {
            skipped = in.skip(todo);
            if (skipped > 0L) continue;
            throw new IOException("Failed to skip " + n + " bytes");
        }
    }

    public long getPosition() {
        return this.current;
    }

    public SharedFileInputStream newStream(long start, long end) {
        try {
            long length = end == -1L ? this.length - start : end - start;
            return new SharedFileInputStream(this, this.start + start, length);
        }
        catch (IOException localIOException) {
            throw new IllegalStateException("unable to create shared stream: " + localIOException);
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        int j;
        int i;
        if (len == 0) {
            return 0;
        }
        for (i = 0; i < len && (j = this.read()) >= 0; ++i) {
            buffer[offset + i] = (byte)j;
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    @Override
    public int read() throws IOException {
        if (this.current == this.length) {
            return -1;
        }
        ++this.current;
        return this.in.read();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public long skip(long len) throws IOException {
        int count = 0;
        while ((long)count < len) {
            if (this.read() < 0) {
                return count;
            }
            ++count;
        }
        return len;
    }

    @Override
    public void mark(int limit) {
        this.marked = this.current;
        this.in.mark(limit);
    }

    @Override
    public void reset() throws IOException {
        this.current = this.marked;
        this.in.reset();
    }

    public SharedFileInputStream getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }
}

