/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.services;

import java.io.IOException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.codehaus.jackson.map.ser.BeanSerializerModifier;

public class JsonFactoryManager {
    private JsonFactory factory;

    public JsonFactory getJsonFactory() {
        if (this.factory == null) {
            this.factory = this.createFactory();
        }
        return this.factory;
    }

    protected JsonFactory createFactory() {
        JsonFactory factory = new JsonFactory();
        ObjectMapper oc = new ObjectMapper(factory);
        SimpleModule module = new SimpleModule("automation", Version.unknownVersion()){

            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanSerializerModifier(new BeanSerializerModifier(){

                    public JsonSerializer<?> modifySerializer(SerializationConfig config, BasicBeanDescription beanDesc, JsonSerializer<?> serializer) {
                        if (!Throwable.class.isAssignableFrom(beanDesc.getBeanClass())) {
                            return super.modifySerializer(config, beanDesc, serializer);
                        }
                        return new ThrowableSerializer((BeanSerializer)serializer);
                    }
                });
            }
        };
        oc.registerModule((Module)module);
        factory.setCodec((ObjectCodec)oc);
        return factory;
    }

    private static class ThrowableSerializer
    extends BeanSerializer {
        public ThrowableSerializer(BeanSerializer src) {
            super(src);
        }

        protected void serializeFields(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            this.serializeClassName(bean, jgen, provider);
            super.serializeFields(bean, jgen, provider);
        }

        protected void serializeFieldsFiltered(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            this.serializeClassName(bean, jgen, provider);
            super.serializeFieldsFiltered(bean, jgen, provider);
        }

        protected void serializeClassName(Object bean, JsonGenerator jgen, SerializerProvider provider) throws JsonGenerationException, IOException {
            jgen.writeFieldName("className");
            jgen.writeString(bean.getClass().getName());
        }
    }
}

