/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodec;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.automation.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.jaxrs.io.operations.AutomationInfo;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.io.JSONLayoutExporter;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.runtime.api.Framework;

public class JsonWriter {
    private static JsonFactory getFactory() {
        return ((JsonFactoryManager)Framework.getLocalService(JsonFactoryManager.class)).getJsonFactory();
    }

    private static JsonGenerator createGenerator(OutputStream out) throws IOException {
        return JsonWriter.getFactory().createJsonGenerator(out, JsonEncoding.UTF8);
    }

    public static void writeAutomationInfo(OutputStream out, AutomationInfo info, boolean prettyPrint) throws IOException {
        JsonWriter.writeAutomationInfo(JsonWriter.createGenerator(out), info, prettyPrint);
    }

    public static void writeAutomationInfo(JsonGenerator jg, AutomationInfo info, boolean prettyPrint) throws IOException {
        if (prettyPrint) {
            jg.useDefaultPrettyPrinter();
        }
        jg.writeStartObject();
        JsonWriter.writePaths(jg);
        JsonWriter.writeCodecs(jg);
        JsonWriter.writeOperations(jg, info);
        JsonWriter.writeChains(jg, info);
        jg.writeEndObject();
        jg.flush();
    }

    private static void writePaths(JsonGenerator jg) throws IOException {
        jg.writeObjectFieldStart("paths");
        jg.writeStringField("login", "login");
        jg.writeEndObject();
    }

    private static void writeCodecs(JsonGenerator jg) throws IOException {
        jg.writeArrayFieldStart("codecs");
        ObjectCodecService codecs = (ObjectCodecService)Framework.getLocalService(ObjectCodecService.class);
        for (ObjectCodec<?> codec : codecs.getCodecs()) {
            if (codec.isBuiltin()) continue;
            jg.writeString(codec.getClass().getName());
        }
        jg.writeEndArray();
    }

    public static String exportOperations() throws IOException, OperationException {
        return JsonWriter.exportOperations(false);
    }

    public static String exportOperations(boolean filterNotInStudio) throws IOException, OperationException {
        List ops = ((AutomationService)Framework.getLocalService(AutomationService.class)).getDocumentation();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator jg = JsonWriter.getFactory().createJsonGenerator((OutputStream)out);
        jg.useDefaultPrettyPrinter();
        jg.writeStartObject();
        jg.writeArrayFieldStart("operations");
        for (OperationDocumentation op : ops) {
            if (filterNotInStudio) {
                if (!op.addToStudio || "Chain".equals(op.category)) continue;
                JsonWriter.writeOperation(jg, op);
                continue;
            }
            JsonWriter.writeOperation(jg, op);
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
        return out.toString("UTF-8");
    }

    private static void writeOperations(JsonGenerator jg, AutomationInfo info) throws IOException {
        jg.writeArrayFieldStart("operations");
        for (OperationDocumentation op : info.getOperations()) {
            JsonWriter.writeOperation(jg, op);
        }
        jg.writeEndArray();
    }

    private static void writeChains(JsonGenerator jg, AutomationInfo info) throws IOException {
        jg.writeArrayFieldStart("chains");
        for (OperationDocumentation op : info.getChains()) {
            JsonWriter.writeOperation(jg, op, "Chain." + op.id);
        }
        jg.writeEndArray();
    }

    public static void writeOperation(OutputStream out, OperationDocumentation op) throws IOException {
        JsonWriter.writeOperation(out, op, false);
    }

    public static void writeOperation(OutputStream out, OperationDocumentation op, boolean prettyPrint) throws IOException {
        JsonWriter.writeOperation(JsonWriter.createGenerator(out), op, prettyPrint);
    }

    public static void writeOperation(JsonGenerator jg, OperationDocumentation op) throws IOException {
        JsonWriter.writeOperation(jg, op, false);
    }

    public static void writeOperation(JsonGenerator jg, OperationDocumentation op, boolean prettyPrint) throws IOException {
        JsonWriter.writeOperation(jg, op, op.url, prettyPrint);
    }

    public static void writeOperation(JsonGenerator jg, OperationDocumentation op, String url) throws IOException {
        JsonWriter.writeOperation(jg, op, url, false);
    }

    public static void writeOperation(JsonGenerator jg, OperationDocumentation op, String url, boolean prettyPrint) throws IOException {
        if (prettyPrint) {
            jg.useDefaultPrettyPrinter();
        }
        jg.writeStartObject();
        jg.writeStringField("id", op.id);
        if (op.getAliases() != null && op.getAliases().length > 0) {
            jg.writeArrayFieldStart("aliases");
            for (String string : op.getAliases()) {
                jg.writeString(string);
            }
            jg.writeEndArray();
        }
        jg.writeStringField("label", op.label);
        jg.writeStringField("category", op.category);
        jg.writeStringField("requires", op.requires);
        jg.writeStringField("description", op.description);
        if (op.since != null && op.since.length() > 0) {
            jg.writeStringField("since", op.since);
        }
        jg.writeStringField("url", url);
        jg.writeArrayFieldStart("signature");
        for (String string : op.signature) {
            jg.writeString(string);
        }
        jg.writeEndArray();
        JsonWriter.writeParams(jg, Arrays.asList(op.params));
        if (op.widgetDefinitions != null && op.widgetDefinitions.length > 0) {
            jg.writeArrayFieldStart("widgets");
            for (String string : op.widgetDefinitions) {
                jg.writeObject((Object)JSONLayoutExporter.exportToJson((WidgetDefinition)string, null, null));
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
        jg.flush();
    }

    private static void writeParams(JsonGenerator jg, List<OperationDocumentation.Param> params) throws IOException {
        jg.writeArrayFieldStart("params");
        for (OperationDocumentation.Param p : params) {
            jg.writeStartObject();
            jg.writeStringField("name", p.name);
            jg.writeStringField("description", p.description);
            jg.writeStringField("type", p.type);
            jg.writeBooleanField("required", p.isRequired);
            jg.writeStringField("widget", p.widget);
            jg.writeNumberField("order", p.order);
            jg.writeArrayFieldStart("values");
            for (String value : p.values) {
                jg.writeString(value);
            }
            jg.writeEndArray();
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    public static void writeLogin(OutputStream out, LoginInfo login) throws IOException {
        JsonWriter.writeLogin(JsonWriter.createGenerator(out), login);
    }

    public static void writeLogin(JsonGenerator jg, LoginInfo login) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", "login");
        jg.writeStringField("username", login.getUsername());
        jg.writeBooleanField("isAdministrator", login.isAdministrator());
        jg.writeArrayFieldStart("groups");
        for (String group : login.getGroups()) {
            jg.writeString(group);
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
    }

    public static void writePrimitive(OutputStream out, Object value) throws IOException {
        JsonWriter.writePrimitive(JsonWriter.createGenerator(out), value);
    }

    public static void writePrimitive(JsonGenerator jg, Object value) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", "primitive");
        if (value != null) {
            Class<?> type = value.getClass();
            if (type == String.class) {
                jg.writeStringField("value", (String)value);
            } else if (type == Boolean.class) {
                jg.writeBooleanField("value", ((Boolean)value).booleanValue());
            } else if (type == Long.class) {
                jg.writeNumberField("value", ((Number)value).longValue());
            } else if (type == Double.class) {
                jg.writeNumberField("value", ((Number)value).doubleValue());
            } else if (type == Integer.class) {
                jg.writeNumberField("value", ((Number)value).intValue());
            } else if (type == Float.class) {
                jg.writeNumberField("value", ((Number)value).floatValue());
            }
        } else {
            jg.writeNullField("value");
        }
        jg.writeEndObject();
        jg.flush();
    }

    @Deprecated
    public static void writeException(OutputStream out, WebException eh) throws IOException {
        JsonWriter.writeException(JsonWriter.createGenerator(out), eh);
    }

    @Deprecated
    public static void writeException(JsonGenerator jg, WebException eh) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", "exception");
        jg.writeStringField("type", eh.getType());
        jg.writeNumberField("status", eh.getStatus());
        jg.writeStringField("message", eh.getMessage());
        jg.writeStringField("stack", eh.getStackTraceString());
        jg.writeObjectField("cause", (Object)eh.getCause());
        jg.writeEndObject();
        jg.flush();
    }
}

