/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="operationActionBean")
@Scope(value=ScopeType.EVENT)
public class OperationActionBean
implements Serializable {
    private static final Log log = LogFactory.getLog(OperationActionBean.class);
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;

    public String doOperation(String chainId) throws Exception {
        return this.runOperation(chainId);
    }

    protected void showError(OperationContext ctx, String chain, Throwable cause) {
        String msg = (String)ctx.get((Object)"Seam.AddErrorMessage");
        if (msg == null) {
            msg = "An error occured while executing the chain '" + chain + "': " + cause.getMessage();
        }
        this.facesMessages.add(StatusMessage.Severity.ERROR, msg, new Object[0]);
    }

    protected void showSuccess(OperationContext ctx, String chain) {
        String msg = (String)ctx.get((Object)"Seam.AddInfoMessage");
        if (msg != null) {
            this.facesMessages.add(StatusMessage.Severity.INFO, msg, new Object[0]);
        }
    }

    protected String runOperation(Object chain) throws Exception {
        AutomationService os = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext ctx = new OperationContext(this.documentManager);
        ctx.setInput((Object)this.navigationContext.getCurrentDocument());
        if (chain instanceof String) {
            try {
                os.run(ctx, (String)chain);
                this.showSuccess(ctx, (String)chain);
            }
            catch (InvalidChainException e) {
                this.facesMessages.add(StatusMessage.Severity.ERROR, "Unknown chain: " + chain, new Object[0]);
                return null;
            }
            catch (Throwable t) {
                log.error((Object)t, t);
                Throwable cause = ExceptionHelper.unwrapException((Throwable)t);
                this.showError(ctx, (String)chain, cause);
                return null;
            }
        } else {
            os.run(ctx, (OperationChain)chain);
            this.showSuccess(ctx, ((OperationChain)chain).getId());
        }
        return (String)ctx.get((Object)"Outcome");
    }
}

