/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchFileEntry;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;

public class Batch {
    protected static final Log log = LogFactory.getLog(Batch.class);
    public static final String CHUNKED_PARAM_NAME = "chunked";
    protected String key;
    protected Map<String, Serializable> fileEntries;
    protected String handlerName;
    protected TransientStore transientStore;
    protected Map<String, Object> properties;

    public Batch(String key, Map<String, Serializable> fileEntries, String handlerName, TransientStore transientStore) {
        this.key = key;
        this.fileEntries = fileEntries;
        this.handlerName = handlerName;
        this.transientStore = transientStore;
        this.properties = new HashMap<String, Object>();
    }

    public String getKey() {
        return this.key;
    }

    public List<Blob> getBlobs() {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        List<String> sortedFileIndexes = this.getOrderedFileIndexes();
        log.debug((Object)String.format("Retrieving blobs for batch %s: %s", this.key, sortedFileIndexes));
        for (String index : sortedFileIndexes) {
            Blob blob = this.retrieveBlob(index);
            if (blob == null) continue;
            blobs.add(blob);
        }
        return blobs;
    }

    public Blob getBlob(String index) {
        log.debug((Object)String.format("Retrieving blob %s for batch %s", index, this.key));
        return this.retrieveBlob(index);
    }

    protected List<String> getOrderedFileIndexes() {
        ArrayList<String> sortedFileIndexes = new ArrayList<String>(this.fileEntries.keySet());
        sortedFileIndexes.sort(Comparator.comparing(Integer::valueOf));
        return sortedFileIndexes;
    }

    protected Blob retrieveBlob(String index) {
        Blob blob = null;
        BatchFileEntry fileEntry = this.getFileEntry(index);
        if (fileEntry != null) {
            blob = fileEntry.getBlob();
        }
        return blob;
    }

    public List<BatchFileEntry> getFileEntries() {
        ArrayList<BatchFileEntry> batchFileEntries = new ArrayList<BatchFileEntry>();
        List<String> sortedFileIndexes = this.getOrderedFileIndexes();
        for (String index : sortedFileIndexes) {
            BatchFileEntry fileEntry = this.getFileEntry(index);
            if (fileEntry == null) continue;
            batchFileEntries.add(fileEntry);
        }
        return batchFileEntries;
    }

    public BatchFileEntry getFileEntry(String index) {
        return this.getFileEntry(index, true);
    }

    public BatchFileEntry getFileEntry(String index, boolean fetchBlobs) {
        String fileEntryKey = (String)((Object)this.fileEntries.get(index));
        if (fileEntryKey == null) {
            return null;
        }
        Map fileEntryParams = this.transientStore.getParameters(fileEntryKey);
        if (fileEntryParams == null) {
            return null;
        }
        boolean chunked = Boolean.parseBoolean((String)fileEntryParams.get(CHUNKED_PARAM_NAME));
        if (chunked) {
            return new BatchFileEntry(this.transientStore, fileEntryKey, fileEntryParams);
        }
        Blob blob = null;
        if (fetchBlobs) {
            List fileEntryBlobs = this.transientStore.getBlobs(fileEntryKey);
            if (fileEntryBlobs == null) {
                return null;
            }
            if (!fileEntryBlobs.isEmpty()) {
                blob = (Blob)fileEntryBlobs.get(0);
            }
        }
        return new BatchFileEntry(this.transientStore, fileEntryKey, blob);
    }

    @Deprecated
    public String addFile(String index, InputStream is, String name, String mime) throws IOException {
        Blob blob = Blobs.createBlob((InputStream)is);
        return this.addFile(index, blob, name, mime);
    }

    public String addFile(String index, Blob blob, String name, String mime) {
        blob.setFilename(name);
        blob.setMimeType(mime);
        String fileEntryKey = this.key + "_" + index;
        this.transientStore.putBlobs(fileEntryKey, Collections.singletonList(blob));
        this.transientStore.putParameter(fileEntryKey, CHUNKED_PARAM_NAME, (Serializable)((Object)String.valueOf(false)));
        this.transientStore.putParameter(this.key, index, (Serializable)((Object)fileEntryKey));
        return fileEntryKey;
    }

    @Deprecated
    public String addChunk(String index, InputStream is, int chunkCount, int chunkIndex, String fileName, String mimeType, long fileSize) throws IOException {
        Blob blob = Blobs.createBlob((InputStream)is);
        return this.addChunk(index, blob, chunkCount, chunkIndex, fileName, mimeType, fileSize);
    }

    public String addChunk(String index, Blob blob, int chunkCount, int chunkIndex, String fileName, String mimeType, long fileSize) {
        String fileEntryKey = this.key + "_" + index;
        BatchFileEntry fileEntry = this.getFileEntry(index);
        if (fileEntry == null) {
            fileEntry = new BatchFileEntry(this.transientStore, fileEntryKey, chunkCount, fileName, mimeType, fileSize);
            this.transientStore.putParameters(fileEntryKey, fileEntry.getParams());
            this.transientStore.putParameter(this.key, index, (Serializable)((Object)fileEntryKey));
        }
        fileEntry.addChunk(chunkIndex, blob);
        return fileEntryKey;
    }

    public void clean() {
        log.debug((Object)String.format("Cleaning batch %s", this.key));
        for (String fileIndex : this.fileEntries.keySet()) {
            this.removeFileEntry(fileIndex, this.transientStore);
        }
        this.transientStore.remove(this.key);
    }

    public boolean removeFileEntry(String index, TransientStore ts) {
        BatchFileEntry fileEntry = this.getFileEntry(index, false);
        if (fileEntry == null) {
            return false;
        }
        if (fileEntry.isChunked()) {
            for (String chunkEntryKey : fileEntry.getChunkEntryKeys()) {
                ts.remove(chunkEntryKey);
            }
            fileEntry.beforeRemove();
        }
        String fileEntryKey = fileEntry.getKey();
        ts.remove(fileEntryKey);
        return true;
    }

    public boolean removeFileEntry(String index) {
        return this.removeFileEntry(index, this.transientStore);
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

