/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonDocumentWriter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.WebException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json+nxentity", "application/json"})
public class JsonDocumentListWriter
implements MessageBodyWriter<DocumentModelList> {
    public long getSize(DocumentModelList arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return DocumentModelList.class.isAssignableFrom(arg0);
    }

    public void writeTo(DocumentModelList docs, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream arg6) throws IOException, WebApplicationException {
        try {
            JSONObject json = new JSONObject();
            JSONArray ar = new JSONArray();
            for (DocumentModel doc : docs) {
                ar.add((Object)JsonDocumentWriter.getJSON(doc, null));
            }
            json.element("entity-type", (Object)"documents");
            json.element("entries", (Collection)ar);
            arg6.write(json.toString(2).getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }
}

