/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomationInfo {
    protected List<OperationDocumentation> ops;
    protected List<OperationDocumentation> chains;

    public AutomationInfo(AutomationService service) {
        this.ops = service.getDocumentation();
        HashMap<String, OperationDocumentation> map = new HashMap<String, OperationDocumentation>();
        for (OperationDocumentation doc : this.ops) {
            map.put(doc.id, doc);
        }
        this.chains = new ArrayList<OperationDocumentation>();
        for (OperationChain chain : service.getOperationChains()) {
            OperationDocumentation doc = new OperationDocumentation(chain.getId());
            doc.description = chain.getDescription();
            doc.category = "Chain";
            doc.label = doc.id;
            doc.params = Collections.emptyList();
            List ops = chain.getOperations();
            if (ops.isEmpty()) {
                doc.signature = new String[]{"void", "void"};
            } else if (ops.size() == 1) {
                OperationDocumentation opdoc = (OperationDocumentation)map.get(((OperationParameters)ops.get(0)).id());
                doc.signature = opdoc.signature;
            } else {
                ArrayList<String[]> sigs = new ArrayList<String[]>();
                for (OperationParameters o : ops) {
                    sigs.add(((OperationDocumentation)map.get((Object)o.id())).signature);
                }
                String[] head = (String[])sigs.get(0);
                ArrayList<String> rs = new ArrayList<String>();
                for (int i = 0; i < head.length; i += 2) {
                    String in = head[i];
                    String out = head[i + 1];
                    ArrayList<String> result = new ArrayList<String>();
                    this.checkPath(out, sigs, 1, result);
                    for (String r : result) {
                        rs.add(in);
                        rs.add(r);
                    }
                }
                doc.signature = rs.toArray(new String[rs.size()]);
            }
            this.chains.add(doc);
        }
    }

    protected void checkPath(String in, List<String[]> sigs, int offset, List<String> result) {
        boolean last = sigs.size() - 1 == offset;
        String[] sig = sigs.get(offset);
        for (int i = 0; i < sig.length; i += 2) {
            if (!"void".equals(in) && !"void".equals(sig[i]) && !in.equals(sig[i])) continue;
            if (last) {
                result.add(sig[i + 1]);
                continue;
            }
            this.checkPath(sig[i + 1], sigs, offset + 1, result);
        }
    }

    public List<OperationDocumentation> getOperations() {
        return this.ops;
    }

    public List<OperationDocumentation> getChains() {
        return this.chains;
    }
}

