/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import net.sf.json.JSONObject;

@Produces(value={"application/json+nxentity", "application/json"})
public class JsonPrimitiveWriter
implements MessageBodyWriter<Object> {
    public long getSize(Object arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    public boolean isWriteable(Class<?> typeClass, Type arg1, Annotation[] arg2, MediaType arg3) {
        if (String.class.isAssignableFrom(typeClass)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(typeClass)) {
            return true;
        }
        return Number.class.isAssignableFrom(typeClass);
    }

    public void writeTo(Object value, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream out) throws IOException, WebApplicationException {
        JSONObject json = new JSONObject();
        json.element("entity-type", (Object)"primitive");
        if (value instanceof Number) {
            if (value instanceof Double) {
                json.element("type", (Object)"double");
            } else if (value instanceof Long) {
                json.element("type", (Object)"long");
            } else {
                json.element("type", (Object)"integer");
            }
        } else if (value instanceof String) {
            json.element("type", (Object)"string");
        } else if (value instanceof Boolean) {
            json.element("type", (Object)"boolean");
        }
        json.element("value", value);
        out.write(json.toString(2).getBytes("UTF-8"));
    }
}

