/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io;

import java.util.HashMap;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonMarshaller;
import org.nuxeo.ecm.automation.server.jaxrs.io.marshallers.DateMarshaller;
import org.nuxeo.ecm.automation.server.jaxrs.io.marshallers.PrimitiveMarshaller;

public class JsonMarshalling {
    protected final HashMap<String, JsonMarshaller<?>> marshallersByType = new HashMap();
    protected final HashMap<Class<?>, JsonMarshaller<?>> marshallersByJavaType = new HashMap();

    public JsonMarshalling() {
        this.addMarshaller(new DateMarshaller());
        this.addMarshaller(new PrimitiveMarshaller<Boolean>(Boolean.class));
        this.addMarshaller(new PrimitiveMarshaller<Integer>(Integer.class));
        this.addMarshaller(new PrimitiveMarshaller<Long>(Long.class));
        this.addMarshaller(new PrimitiveMarshaller<Double>(Double.class));
        this.addMarshaller(new PrimitiveMarshaller<String>(String.class));
    }

    public void addMarshaller(JsonMarshaller<?> marshaller) {
        this.marshallersByJavaType.put(marshaller.getJavaType(), marshaller);
        this.marshallersByType.put(marshaller.getType(), marshaller);
    }

    public void removeMarshaller(Class<?> clazz) {
        JsonMarshaller<?> marshaller = this.marshallersByJavaType.remove(clazz);
        if (marshaller == null) {
            throw new IllegalArgumentException("no registered marshaller for " + clazz.getName());
        }
        this.marshallersByType.remove(marshaller.getType());
    }

    public boolean canMarshall(Class<?> clazz) {
        return this.getMarshaller(clazz) != null;
    }

    public <T> JsonMarshaller<T> getMarshaller(String type) {
        JsonMarshaller<?> js = this.marshallersByType.get(type);
        return js;
    }

    public <T> JsonMarshaller<T> getMarshaller(Class<T> clazz) {
        JsonMarshaller<?> js = this.marshallersByJavaType.get(clazz);
        return js;
    }

    public <T> void write(Class<T> clazz, JSONObject object, Object value) {
        JsonMarshaller<T> m = this.getMarshaller(clazz);
        if (m == null) {
            throw new IllegalArgumentException("no json marshaller for " + clazz);
        }
        m.write(object, value);
    }

    public <T> T read(String type, JSONObject object) {
        JsonMarshaller<T> m = this.getMarshaller(type);
        if (m == null) {
            throw new IllegalArgumentException("no json marshaller for " + type);
        }
        return m.read(object);
    }
}

