/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io.marshallers;

import java.util.Map;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonMarshaller;

public class BeanMarshaller<T>
implements JsonMarshaller<T> {
    protected final Class<T> clazz;
    protected final JsonConfig config;

    public BeanMarshaller(Class<T> clazz) {
        this.clazz = clazz;
        this.config = new JsonConfig();
        this.config.setRootClass(clazz);
    }

    @Override
    public String getType() {
        return this.clazz.getSimpleName().toLowerCase();
    }

    @Override
    public Class<T> getJavaType() {
        return this.clazz;
    }

    @Override
    public T resolveReference(String ref) {
        return this.read(JSONObject.fromObject((Object)ref, (JsonConfig)this.config));
    }

    @Override
    public String newReference(T value) {
        JSONObject json = new JSONObject();
        this.write(json, value);
        return json.toString(2);
    }

    @Override
    public T read(JSONObject json) {
        return this.clazz.cast(JSONObject.toBean((JSONObject)json, (JsonConfig)this.config));
    }

    @Override
    public void write(JSONObject json, Object value) {
        JSONObject o = JSONObject.fromObject((Object)value, (JsonConfig)this.config);
        for (Object e : o.entrySet()) {
            Map.Entry me = (Map.Entry)e;
            json.put(me.getKey(), me.getValue());
        }
    }
}

