/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io.marshallers;

import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonMarshaller;

public final class PrimitiveMarshaller<T>
implements JsonMarshaller<T> {
    protected final Class<T> clazz;
    protected final String type;

    public PrimitiveMarshaller(Class<T> clazz) {
        this.clazz = clazz;
        this.type = clazz.getSimpleName().toLowerCase();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Class<T> getJavaType() {
        return this.clazz;
    }

    @Override
    public T resolveReference(String ref) {
        if (this.type.equals("boolean")) {
            return this.clazz.cast(Boolean.valueOf(ref));
        }
        if (this.type.equals("string")) {
            return this.clazz.cast(ref);
        }
        if (this.type.equals("integer")) {
            return this.clazz.cast(Integer.valueOf(ref));
        }
        if (this.type.equals("long")) {
            return this.clazz.cast(Long.valueOf(ref));
        }
        if (this.type.equals("double")) {
            return this.clazz.cast(Double.valueOf(ref));
        }
        throw new UnsupportedOperationException("cannot decode " + this.type);
    }

    @Override
    public String newReference(T value) {
        return value.toString();
    }

    @Override
    public T read(JSONObject json) {
        return this.clazz.cast(json.get(this.type));
    }

    @Override
    public void write(JSONObject json, Object value) {
        json.put((Object)this.type, value);
    }
}

