/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.server.jaxrs.DefaultJsonAdapter;
import org.nuxeo.ecm.automation.server.jaxrs.JsonAdapter;
import org.nuxeo.ecm.automation.server.jaxrs.io.MultipartBlobs;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;

public class ResponseHelper {
    private ResponseHelper() {
    }

    public static Response notFound() {
        return Response.status((int)404).build();
    }

    public static Response emptyContent() {
        return Response.status((int)204).build();
    }

    public static Response notAllowed() {
        return Response.status((int)401).build();
    }

    public static Response blob(Blob blob) {
        String type = blob.getMimeType();
        if (type == null || "???".equals(type)) {
            type = "application/octet-stream";
        }
        return Response.ok((Object)blob).type(type).header("Content-Disposition", (Object)("attachment; filename=" + blob.getFilename())).build();
    }

    public static Response blobs(List<Blob> blobs) throws Exception {
        return new MultipartBlobs(blobs).getResponse();
    }

    public static Object getResponse(Object result, HttpServletRequest request) throws Exception {
        if (result == null) {
            return null;
        }
        if ("true".equals(request.getHeader("X-NXVoidOperation"))) {
            return ResponseHelper.emptyContent();
        }
        if (result instanceof Blob) {
            return ResponseHelper.blob((Blob)result);
        }
        if (result instanceof BlobList) {
            return ResponseHelper.blobs((List<Blob>)((BlobList)result));
        }
        if (result instanceof DocumentRef) {
            CoreSession session = SessionFactory.getSession((HttpServletRequest)request);
            return session.getDocument((DocumentRef)result);
        }
        if (result instanceof DocumentModel || result instanceof DocumentModelList || result instanceof JsonAdapter) {
            return result;
        }
        return new DefaultJsonAdapter(result);
    }
}

