/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class ObjectCodec<T> {
    protected Class<T> type;

    public static Class<?> findParametrizedType(Class<?> clazz) {
        Type superclass = clazz.getGenericSuperclass();
        while (superclass instanceof Class) {
            superclass = ((Class)superclass).getGenericSuperclass();
        }
        if (superclass == null) {
            throw new RuntimeException("Missing type parameter.");
        }
        Type type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        if (!(type instanceof Class)) {
            throw new RuntimeException("Invalid class parameter type. " + type);
        }
        return (Class)type;
    }

    public ObjectCodec() {
        this.type = ObjectCodec.findParametrizedType(this.getClass());
    }

    public ObjectCodec(Class<T> type) {
        this.type = type;
    }

    public String getType() {
        return this.type.getName();
    }

    public boolean isBuiltin() {
        return false;
    }

    public Class<T> getJavaType() {
        return this.type;
    }

    public void write(JsonGenerator jg, T value) throws IOException {
        if (jg.getCodec() == null) {
            jg.setCodec((org.codehaus.jackson.ObjectCodec)new ObjectMapper());
        }
        jg.writeObject(value);
    }

    public T read(JsonParser jp) throws IOException {
        if (jp.getCodec() == null) {
            jp.setCodec((org.codehaus.jackson.ObjectCodec)new ObjectMapper());
        }
        return (T)jp.readValueAs(this.type);
    }
}

