/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.Map;

public class AutomationScope
implements Scope {
    public static final AutomationScope INSTANCE = new AutomationScope();
    protected final ThreadLocal<Map<Key<?>, Object>> values = new ThreadLocal<Map<Key<?>, Object>>(){

        @Override
        protected Map<Key<?>, Object> initialValue() {
            return new HashMap();
        }
    };

    protected AutomationScope() {
    }

    public void enter() {
        this.values.get();
    }

    public void exit() {
        this.values.remove();
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                Map<Key<?>, Object> scopedMap = AutomationScope.this.getScopedObjectMap(key);
                Object current = scopedMap.get(key);
                if (current == null && !scopedMap.containsKey(key)) {
                    current = unscoped.get();
                    scopedMap.put(key, current);
                }
                return current;
            }
        };
    }

    private <T> Map<Key<?>, Object> getScopedObjectMap(Key<T> key) {
        Map<Key<?>, Object> scopedObjects = this.values.get();
        if (scopedObjects == null) {
            throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
        }
        return scopedObjects;
    }
}

