/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.io.IOException;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.AsyncSession;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.test.AutomationServerFeature;
import org.nuxeo.ecm.core.test.DetectThreadDeadlocksFeature;
import org.nuxeo.ecm.webengine.test.WebEngineFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.ServletContainerFeature;

@Features(value={DetectThreadDeadlocksFeature.class, WebEngineFeature.class, AutomationServerFeature.class})
public class EmbeddedAutomationServerFeature
implements RunnerFeature {
    protected static final int HTTP_CONNECTION_TIMEOUT = 60000;
    @Inject
    protected ServletContainerFeature servletContainerFeature;
    protected HttpAutomationClient client;
    protected Session session;

    public void afterRun(FeaturesRunner runner) {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
            this.session = null;
        }
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(HttpAutomationClient.class).toProvider(() -> {
            if (this.client == null) {
                this.client = this.getHttpAutomationClient();
            }
            return this.client;
        }).in(Scopes.SINGLETON);
        binder.bind(Session.class).toProvider(() -> {
            if (this.client == null) {
                this.client = this.getHttpAutomationClient();
            }
            if (this.session == null) {
                try {
                    this.session = this.client.getSession("Administrator", "Administrator");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.session;
        }).in(Scopes.SINGLETON);
        binder.bind(AsyncSession.class).toProvider(() -> {
            if (this.client == null) {
                this.client = this.getHttpAutomationClient();
            }
            if (this.session == null) {
                try {
                    this.session = this.client.getSession("Administrator", "Administrator");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return (AsyncSession)this.session.getAdapter(AsyncSession.class);
        }).in(Scopes.SINGLETON);
    }

    protected HttpAutomationClient getHttpAutomationClient() {
        Supplier<String> urlSupplier = () -> "http://localhost:" + this.servletContainerFeature.getPort() + "/automation/";
        HttpAutomationClient client = new HttpAutomationClient(urlSupplier, 60000);
        client.setSharedRegistryExpirationDelay(0L);
        return client;
    }
}

