/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.DummyCreateDocument;
import org.nuxeo.ecm.automation.core.operations.document.CreateDocument;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.automation.test.AutomationServerFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={AutomationServerFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.test"}), @Deploy(value={"org.nuxeo.ecm.webengine.core"})})
public class TestOperationRegistration {
    @Inject
    AutomationService service;
    @Inject
    ObjectCodecService objectCodecService;

    @Test
    public void testRegistration() throws Exception {
        OperationType op = this.service.getOperation("Document.Create");
        Assert.assertEquals(CreateDocument.class, (Object)op.getType());
        try {
            this.service.putOperation(DummyCreateDocument.class);
        }
        catch (OperationException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("An operation is already bound to: Document.Create"));
        }
        op = this.service.getOperation("Document.Create");
        Assert.assertEquals(CreateDocument.class, (Object)op.getType());
        this.service.putOperation(DummyCreateDocument.class, true);
        try {
            op = this.service.getOperation("Document.Create");
        }
        catch (OperationException operationException) {
            // empty catch block
        }
        Assert.assertEquals(DummyCreateDocument.class, (Object)op.getType());
    }
}

