/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.IOException;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.platform.test.PlatformFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={PlatformFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.core"})
public class TestBulkDownloadOperation {
    private static final int MAX_DOC = 10;
    @Inject
    protected DownloadService downloadService;
    @Inject
    protected CoreSession session;
    @Inject
    protected AutomationService automationService;
    @Inject
    CoreFeature coreFeature;

    @Test
    public void iCanBulkDownloadFiles() throws IOException, OperationException, InterruptedException {
        this.testWithNbFiles(10);
    }

    @Test
    public void iCanBulkDownloadASingleFile() throws IOException, OperationException, InterruptedException {
        this.testWithNbFiles(1);
    }

    protected void testWithNbFiles(int nbDocs) throws IOException, OperationException, InterruptedException {
        Blob blob;
        DocumentModelListImpl docs = new DocumentModelListImpl();
        for (int i = 0; i < nbDocs; ++i) {
            DocumentModel doc = this.session.createDocumentModel("/", "TestFile" + i, "File");
            doc.setProperty("dublincore", "title", (Object)("TestTitle" + i));
            Blob blob1 = Blobs.createBlob((String)("test" + i));
            String blobFilename = "test" + i + ".txt";
            blob1.setFilename(blobFilename);
            BlobHolder bh1 = (BlobHolder)doc.getAdapter(BlobHolder.class);
            bh1.setBlob(blob1);
            doc = this.session.createDocument(doc);
            this.session.save();
            docs.add((Object)doc);
        }
        this.coreFeature.waitForAsyncCompletion();
        OperationChain chain = new OperationChain("test-chain");
        chain.add("Blob.BulkDownload");
        try (OperationContext ctx = new OperationContext(this.session);){
            ctx.setInput((Object)docs);
            blob = (Blob)this.automationService.run(ctx, "Blob.BulkDownload");
        }
        Assert.assertNotNull((Object)blob);
        Assert.assertTrue((blob.getLength() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)"application/zip", (Object)blob.getMimeType());
        try (CloseableFile source = blob.getCloseableFile();
             ZipFile zip = new ZipFile(source.getFile());){
            Assert.assertEquals((long)nbDocs, (long)zip.size());
        }
    }
}

