/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.server.test.json.POJOObject;

@Operation(id="Operation.NestedJSONOperation", category="Execution Context", label="NestedJSONOperation")
public class NestedJSONOperation {
    public static final String ID = "Operation.NestedJSONOperation";
    @Param(name="doubleParam", required=false)
    Double doubleParam;
    @Param(name="pojo", required=false)
    POJOObject pojoParam = new POJOObject();
    @Param(name="map", required=false)
    Map<String, Object> mapParam = new HashMap<String, Object>();

    @OperationMethod
    public POJOObject run(List<String> newItems) {
        Object mergedTexts = "Merged texts: ";
        ArrayList<String> mergedItems = new ArrayList<String>();
        if (newItems != null) {
            mergedItems.addAll(newItems);
        }
        mergedTexts = (String)mergedTexts + this.pojoParam.getTextContent();
        mergedItems.addAll(this.pojoParam.getItems());
        if (this.mapParam.containsKey("textContent")) {
            mergedTexts = (String)mergedTexts + this.mapParam.get("textContent").toString();
        }
        if (this.mapParam.containsKey("items") && this.mapParam.get("items") instanceof Collection) {
            mergedItems.addAll((Collection)this.mapParam.get("items"));
        }
        if (this.doubleParam != null) {
            mergedItems.add(this.doubleParam.toString());
        }
        return new POJOObject((String)mergedTexts, mergedItems);
    }

    @OperationMethod
    public POJOObject run() {
        return this.run(new ArrayList<String>());
    }

    @OperationMethod
    public POJOObject run(Map<String, Object> input) {
        ObjectMapper mapper = new ObjectMapper();
        return this.run(((POJOObject)mapper.convertValue(input, POJOObject.class)).getItems());
    }

    @OperationMethod
    public POJOObject run(POJOObject input) {
        return this.run(input.getItems());
    }

    @OperationMethod
    public Integer run(Double input) {
        return (int)input.doubleValue();
    }
}

