/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import java.io.Serializable;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.test.AutomationFeature;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.mail.SmtpMailServerFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class, SmtpMailServerFeature.class, AutomationFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.platform.notification.core"}), @Deploy(value={"org.nuxeo.ecm.platform.notification.api"}), @Deploy(value={"org.nuxeo.ecm.platform.url.api"}), @Deploy(value={"org.nuxeo.ecm.platform.url.core"})})
public class SendMailTest {
    protected DocumentModel src;
    @Inject
    AutomationService service;
    @Inject
    CoreSession session;
    @Inject
    protected SmtpMailServerFeature.MailsResult emailsResult;
    protected OperationContext ctx;

    @Before
    public void initRepo() throws Exception {
        this.session.removeChildren(this.session.getRootDocument().getRef());
        this.session.save();
        this.src = this.session.createDocumentModel("/", "src", "File");
        this.src.setPropertyValue("dc:title", (Serializable)((Object)"Source"));
        this.src = this.session.createDocument(this.src);
        this.session.save();
        this.src = this.session.getDocument(this.src.getRef());
        this.ctx = new OperationContext(this.session);
    }

    @After
    public void closeOperationContext() {
        this.ctx.close();
    }

    @Test
    public void testSendMail() throws Exception {
        Blob blob = Blobs.createBlob((String)"my content");
        blob.setFilename("thefile.txt");
        this.ctx.setInput((Object)this.src);
        OperationChain chain = new OperationChain("sendEMail");
        chain.add("Context.FetchDocument");
        chain.add("Document.SetBlob").set("file", (Object)blob);
        chain.add("Document.Mail").set("from", (Object)"test@nuxeo.org").set("to", (Object)"bs@nuxeo.com").set("subject", (Object)"test mail").set("asHTML", (Object)true).set("files", (Object)"file:content").set("message", (Object)"<h3>Current doc: ${Document.path}</h3> title: ${Document['dc:title']}<p>Doc link: <a href=\"${docUrl}\">${Document.title}</a>");
        this.service.run(this.ctx, chain);
        Assert.assertEquals((long)1L, (long)this.emailsResult.getSize());
        this.emailsResult.assertSender("test@nuxeo.org", 1);
        this.emailsResult.assertRecipient("bs@nuxeo.com", 1);
        Assert.assertTrue((boolean)this.emailsResult.hasSubject("test mail"));
        Assert.assertNotNull((Object)((SmtpMailServerFeature.MailMessage)this.emailsResult.getMails().get(0)).getDate());
    }
}

