/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import java.io.Serializable;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class, LogCaptureFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.core"}), @Deploy(value={"org.nuxeo.ecm.automation.features"})})
@LogCaptureFeature.FilterOn(loggerName="loggerName", logLevel="ERROR")
public class TestRestoreInputFromScriptAndLogOperation {
    @Inject
    AutomationService service;
    @Inject
    CoreSession session;
    @Inject
    LogCaptureFeature.Result logCaptureResult;
    protected OperationContext ctx;

    @Before
    public void createOperationContext() {
        this.ctx = new OperationContext(this.session);
    }

    @After
    public void closeOperationContext() {
        this.ctx.close();
    }

    @Test
    public void testRestoreInput() throws Exception {
        DocumentModel doc = this.session.createDocumentModel("/", "test", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"test"));
        doc = this.session.createDocument(doc);
        this.ctx.setInput((Object)doc);
        OperationChain chain = new OperationChain("testSetObjectInput");
        chain.add("Context.FetchDocument");
        chain.add("Context.SetInputAsVar").set("name", (Object)"test");
        chain.add("Repository.GetDocument").set("value", (Object)"/");
        chain.add("Context.RestoreDocumentInputFromScript").set("script", (Object)"Context[\"test\"]");
        chain.add("Log").set("category", (Object)"loggerName").set("message", (Object)"expr:Input title @{This.title}.").set("level", (Object)"error");
        DocumentModel returnedDoc = (DocumentModel)this.service.run(this.ctx, chain);
        Assert.assertEquals((Object)"/test", (Object)returnedDoc.getPathAsString());
        this.logCaptureResult.assertHasEvent();
    }
}

