/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.AsyncSession;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.core.bulk.CoreBulkFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.TransactionalFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={EmbeddedAutomationServerFeature.class, CoreBulkFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.test"}), @Deploy(value={"org.nuxeo.ecm.automation.test:operation-contrib.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test:test-bindings.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test.test:test-page-provider.xml"})})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class AsyncOperationAdapterTest {
    @Inject
    protected Session session;
    @Inject
    protected AsyncSession async;
    @Inject
    public TransactionalFeature txFeature;

    @Test
    public void testAsyncOperation() throws Exception {
        Object r = this.async.newRequest("TestReturn").setInput((Object)Boolean.TRUE).execute();
        Assert.assertThat((Object)r, (Matcher)Matchers.is((Object)Boolean.TRUE));
        r = this.async.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Assert.assertThat((Object)r, (Matcher)Matchers.instanceOf(Document.class));
        r = this.async.newRequest("Repository.Query").set("query", (Object)"SELECT * from Document").execute();
        Assert.assertThat((Object)r, (Matcher)Matchers.instanceOf(Documents.class));
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"Folder").set("name", (Object)"asyncTest").execute();
        Document file = (Document)this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"File").set("name", (Object)"blobs").execute();
        File tmp = Framework.createTempFile((String)"async-operation-test-", (String)".xml");
        FileUtils.writeStringToFile((File)tmp, (String)"<doc>mydoc1</doc>", (Charset)StandardCharsets.UTF_8);
        FileBlob fb = new FileBlob(tmp);
        fb.setMimeType("text/xml");
        this.session.newRequest("Blob.AttachOnDocument").setHeader("X-NXVoidOperation", "true").setInput((Object)fb).set("document", (Object)file.getPath()).execute();
        r = this.async.newRequest("Document.GetBlob").setInput((Object)file).execute();
        Assert.assertThat((Object)r, (Matcher)Matchers.instanceOf(Blob.class));
    }

    @Test
    public void testAsyncChain() throws Exception {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"Folder").set("name", (Object)"chainTest").execute();
        Document doc = (Document)this.async.newRequest("testchain").setInput((Object)folder).execute();
        TestCase.assertEquals((String)"/chainTest/chain.doc", (String)doc.getPath());
        TestCase.assertEquals((String)"Note", (String)doc.getType());
    }

    @Test
    public void testError() throws Exception {
        Object r = this.session.newRequest("Test.Exit").setInput((Object)"Error").execute();
        TestCase.assertEquals((Object)"Error", (Object)r);
        try {
            r = this.async.newRequest("Test.Exit").set("error", (Object)true).set("rollback", (Object)true).execute();
            Assert.fail((String)"expected error");
        }
        catch (RemoteException e) {
            TestCase.assertEquals((int)500, (int)e.getStatus());
            TestCase.assertEquals((String)"Failed to invoke operation Test.Exit", (String)e.getMessage());
        }
    }

    @Test
    public void testAsyncBulkAction() throws Exception {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"Folder").set("name", (Object)"test").execute();
        HashMap<String, String> automationParams = new HashMap<String, String>();
        automationParams.put("properties", "dc:title=foo");
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        actionParams.put("operationId", "Document.Update");
        actionParams.put("parameters", automationParams);
        Object r = this.async.newRequest("Bulk.RunAction").set("action", (Object)"automation").set("query", (Object)"SELECT * FROM Folder").set("bucketSize", (Object)"10").set("batchSize", (Object)"5").set("parameters", (Object)new ObjectMapper().writeValueAsString(actionParams)).execute();
        Assert.assertNotNull((Object)r);
        this.txFeature.nextTransaction();
        folder = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test").execute();
        TestCase.assertEquals((String)"foo", (String)folder.getTitle());
    }

    @Test
    public void testAsyncBulkActionWithPPWhereClause() throws IOException {
        this.testAsyncBulkActionWithPP("QuickFilterPageProvider");
    }

    @Test
    public void testAsyncBulkActionWithPPPattern() throws IOException {
        this.testAsyncBulkActionWithPP("PageProvider");
    }

    protected void testAsyncBulkActionWithPP(String pageProviderName) throws IOException {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"Folder").set("name", (Object)"test").execute();
        Document file = (Document)this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"File").set("name", (Object)"file").execute();
        HashMap<String, String> automationParams = new HashMap<String, String>();
        automationParams.put("properties", "dc:title=foo");
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        actionParams.put("operationId", "Document.Update");
        actionParams.put("parameters", automationParams);
        Object r = this.async.newRequest("Bulk.RunAction").set("action", (Object)"automation").set("providerName", (Object)pageProviderName).set("quickFilters", (Object)"FileOnly").set("bucketSize", (Object)"10").set("batchSize", (Object)"5").set("parameters", (Object)new ObjectMapper().writeValueAsString(actionParams)).execute();
        Assert.assertNotNull((Object)r);
        this.txFeature.nextTransaction();
        folder = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test").execute();
        file = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test/file").execute();
        TestCase.assertEquals((String)"test", (String)folder.getTitle());
        TestCase.assertEquals((String)"foo", (String)file.getTitle());
    }
}

