/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.io.IOException;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.nuxeo.ecm.automation.test.AutomationServerFeature;
import org.nuxeo.ecm.automation.test.HttpAutomationClient;
import org.nuxeo.ecm.automation.test.HttpAutomationSession;
import org.nuxeo.ecm.core.test.DetectThreadDeadlocksFeature;
import org.nuxeo.ecm.webengine.test.WebEngineFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.ServletContainerFeature;

@Features(value={DetectThreadDeadlocksFeature.class, WebEngineFeature.class, AutomationServerFeature.class})
public class EmbeddedAutomationServerFeature
implements RunnerFeature {
    @Inject
    protected ServletContainerFeature servletContainerFeature;
    protected HttpAutomationClient client;
    protected HttpAutomationSession session;

    public void afterRun(FeaturesRunner runner) {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
            this.session = null;
        }
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(HttpAutomationClient.class).toProvider(() -> {
            if (this.client == null) {
                this.client = this.getHttpAutomationClient();
            }
            return this.client;
        }).in(Scopes.SINGLETON);
        binder.bind(HttpAutomationSession.class).toProvider(() -> {
            if (this.client == null) {
                this.client = this.getHttpAutomationClient();
            }
            if (this.session == null) {
                try {
                    this.session = this.client.getSession("Administrator", "Administrator");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.session;
        }).in(Scopes.SINGLETON);
    }

    protected HttpAutomationClient getHttpAutomationClient() {
        Supplier<String> urlSupplier = () -> "http://localhost:" + this.servletContainerFeature.getPort() + "/automation/";
        HttpAutomationClient client = new HttpAutomationClient(urlSupplier);
        return client;
    }
}

