/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodec;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.automation.server.AutomationServerComponent;
import org.nuxeo.ecm.automation.server.test.AbstractAutomationClientTest;
import org.nuxeo.ecm.automation.server.test.MyObjectCodec;
import org.nuxeo.ecm.automation.server.test.MyObjectOperation;
import org.nuxeo.ecm.automation.server.test.TestDataCapsule;
import org.nuxeo.ecm.automation.server.test.business.client.BusinessBean;
import org.nuxeo.ecm.automation.server.test.json.JSONOperationWithArrays;
import org.nuxeo.ecm.automation.server.test.json.POJOObject;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.automation.test.HttpAutomationRequest;
import org.nuxeo.ecm.automation.test.HttpAutomationSession;
import org.nuxeo.ecm.automation.test.adapter.BusinessBeanAdapter;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.platform.audit.AuditFeature;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.TransactionalFeature;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.platform.url.api"}), @Deploy(value={"org.nuxeo.ecm.platform.url.core"}), @Deploy(value={"org.nuxeo.ecm.platform.types.api"}), @Deploy(value={"org.nuxeo.ecm.platform.types.core"}), @Deploy(value={"org.nuxeo.ecm.platform.notification.core:OSGI-INF/NotificationService.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test"}), @Deploy(value={"org.nuxeo.ecm.automation.test:test-bindings.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test:test-mvalues.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test:operation-contrib.xml"})})
@Features(value={EmbeddedAutomationServerFeature.class, AuditFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class EmbeddedAutomationClientTest
extends AbstractAutomationClientTest {
    protected static String[] attachments = new String[]{"att1", "att2", "att3"};
    @Inject
    UserManager userManager;
    @Inject
    private TransactionalFeature txFeature;

    @BeforeClass
    public static void setupCodecs() throws Exception {
        ((ObjectCodecService)Framework.getService(ObjectCodecService.class)).addCodec((ObjectCodec)new MyObjectCodec());
        ((AutomationService)Framework.getService(AutomationService.class)).putOperation(MyObjectOperation.class);
        ComponentInstance componentInstance = Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.automation.server.AutomationServer");
        AutomationServerComponent automationServerComponent = (AutomationServerComponent)componentInstance.getInstance();
        automationServerComponent.start((ComponentContext)componentInstance);
    }

    public void setupComplexDocuments() throws Exception {
        HashMap<String, Object> creationProps = new HashMap<String, Object>();
        creationProps.put("ds:tableName", "MyTable");
        creationProps.put("ds:attachments", attachments);
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"creationFields.json");
        Assert.assertNotNull((Object)fieldAsJsonFile);
        String fieldsDataAsJSon = org.apache.commons.io.FileUtils.readFileToString((File)fieldAsJsonFile, (Charset)StandardCharsets.UTF_8);
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\n", "");
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\r", "");
        creationProps.put("ds:fields", fieldsDataAsJSon);
        creationProps.put("dc:title", "testDoc");
        this.session.newRequest("Document.Create").setInput((Object)"doc:/").set("type", (Object)"DataSet").set("name", (Object)"testDoc").set("properties", (Object)this.session.propertyMapToString(creationProps)).execute();
    }

    @BeforeClass
    public static void addDataCapsuleOperation() throws OperationException {
        ((AutomationService)Framework.getService(AutomationService.class)).putOperation(TestDataCapsule.class);
    }

    @Test
    public void testBlobSummaries() throws Exception {
        Blob blob = this.session.newRequest("TestDataCapsule").executeReturningBlob();
        Assert.assertEquals((Object)"TestDataCapsule", (Object)blob.getFilename());
        Assert.assertEquals((Object)"application/json", (Object)blob.getMimeType());
        Assert.assertEquals((long)25L, (long)blob.getLength());
    }

    @Test
    public void testCodecs() throws Exception {
        JsonNode msg = this.session.newRequest("Operation.MyObjectTest").execute();
        Assert.assertEquals((Object)"msg", (Object)msg.get("entity-type").asText());
        Assert.assertEquals((Object)"hello world", (Object)msg.get("value").get("message").asText());
    }

    @Test
    public void testMultiValued() throws Exception {
        JsonNode note = this.session.newRequest("Document.Create").setHeader("X-NXDocumentProperties", "*").setInput((Object)"doc:/").set("type", (Object)"MV").set("name", (Object)"pfff").set("properties", (Object)"mv:sl=s1,s2\nmv:ss=s1,s2\nmv:bl=true,false\nmv:b=true\n").executeReturningDocument();
        this.checkHasCorrectMultiValues(note);
        List docs = this.session.newRequest("Repository.Query").setHeader("X-NXDocumentProperties", "*").set("query", (Object)"SELECT * from MV").set("queryParams", (Object)new String[0]).set("pageSize", (Object)2).executeReturningDocuments();
        Assert.assertNotNull((Object)docs);
        Assert.assertEquals((long)1L, (long)docs.size());
        this.checkHasCorrectMultiValues((JsonNode)docs.get(0));
    }

    private void checkHasCorrectMultiValues(JsonNode note) {
        Assert.assertNotNull((Object)note);
        JsonNode properties = this.getProperties(note);
        Assert.assertNotNull((Object)properties);
        JsonNode sl = properties.get("mv:sl");
        Assert.assertNotNull((Object)sl);
        Assert.assertTrue((boolean)sl.isArray());
        Assert.assertEquals((Object)"[\"s1\",\"s2\"]", (Object)sl.toString());
        JsonNode ss = properties.get("mv:ss");
        Assert.assertNotNull((Object)ss);
        Assert.assertTrue((boolean)ss.isArray());
        Assert.assertEquals((Object)"[\"s1\",\"s2\"]", (Object)ss.toString());
        JsonNode b = properties.get("mv:b");
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)b.isBoolean());
        Assert.assertEquals((Object)"true", (Object)b.toString());
        JsonNode bl = properties.get("mv:bl");
        Assert.assertNotNull((Object)bl);
        Assert.assertTrue((boolean)ss.isArray());
        Assert.assertEquals((Object)"[true,false]", (Object)bl.toString());
    }

    @Test
    public void testChain() throws Exception {
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)"doc:/").set("type", (Object)"Folder").set("name", (Object)"chainTest").executeReturningDocument();
        JsonNode doc = this.session.newRequest("testchain").setInput((Object)folder).executeReturningDocument();
        Assert.assertEquals((Object)"/chainTest/chain.doc", (Object)this.getPath(doc));
        Assert.assertEquals((Object)"Note", (Object)doc.get("type").asText());
        doc = this.session.newRequest("Repository.GetDocument").set("value", (Object)doc).executeReturningDocument();
        Assert.assertEquals((Object)"/chainTest/chain.doc", (Object)this.getPath(doc));
        Assert.assertEquals((Object)"Note", (Object)doc.get("type").asText());
    }

    @Test
    public void testRemoteChain() throws Exception {
        JsonNode doc = this.session.newRequest("testchain").setInput((Object)"doc:/").executeReturningDocument();
        Assert.assertNotNull((Object)doc);
    }

    @Test
    public void testTxTimeout() throws Exception {
        this.session.newRequest("WaitForTxTimeout").setHeader("Nuxeo-Transaction-Timeout", "1").executeReturningExceptionEntity(500);
    }

    @Test
    public void testBaseInputAndReturnValues() throws Exception {
        boolean b = this.session.newRequest("TestReturn").setInput((Object)Boolean.TRUE).executeReturningBooleanEntity();
        Assert.assertTrue((boolean)b);
        String s = this.session.newRequest("TestReturn").setInput((Object)"hello").executeReturningStringEntity();
        Assert.assertEquals((Object)"hello", (Object)s);
        Number n = this.session.newRequest("TestReturn").setInput((Object)1).executeReturningNumberEntity();
        Assert.assertEquals((long)1L, (long)n.intValue());
        n = this.session.newRequest("TestReturn").setInput((Object)1000000000000000000L).executeReturningNumberEntity();
        Assert.assertEquals((long)1000000000000000000L, (long)n.longValue());
        n = this.session.newRequest("TestReturn").setInput((Object)1.1).executeReturningNumberEntity();
        Assert.assertEquals((double)1.1, (double)n.doubleValue(), (double)0.1);
        Date now = new Date(0L);
        Instant i = this.session.newRequest("TestReturn").setInput((Object)now).executeReturningDateEntity();
        Assert.assertEquals((Object)now.toInstant(), (Object)i);
    }

    @Test
    public void testNumberParamAdapters() throws Exception {
        Long longParam = 500L;
        Number n = this.session.newRequest("TestNumberParamAdaptersOperation").set("longParam", (Object)longParam).executeReturningNumberEntity();
        Assert.assertEquals((long)500L, (long)n.intValue());
        Integer integerParam = 500;
        n = this.session.newRequest("TestNumberParamAdaptersOperation").set("longParam", (Object)integerParam).executeReturningNumberEntity();
        Assert.assertEquals((long)500L, (long)n.intValue());
    }

    @Test
    public void testChainRollback() throws Exception {
        JsonNode doc = this.session.newRequest("exitNoRollback").setInput((Object)"doc:/").executeReturningDocument();
        Assert.assertEquals((Object)"/test-exit1", (Object)this.getPath(doc));
        JsonNode note = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test-exit1").executeReturningDocument();
        Assert.assertEquals((Object)"/test-exit1", (Object)this.getPath(note));
        doc = this.session.newRequest("exitRollback").setInput((Object)"doc:/").executeReturningDocument();
        Assert.assertEquals((Object)"/test-exit2", (Object)this.getPath(doc));
        String error = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test-exit2").executeReturningExceptionEntity(404);
        Assert.assertEquals((Object)"Failed to invoke operation: Repository.GetDocument, /test-exit2", (Object)error);
        error = this.session.newRequest("exitError").setInput((Object)"doc:/").executeReturningExceptionEntity(500);
        Assert.assertEquals((Object)"Failed to invoke operation: exitError", (Object)error);
        error = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test-exit3").executeReturningExceptionEntity(404);
        Assert.assertEquals((Object)"Failed to invoke operation: Repository.GetDocument, /test-exit3", (Object)error);
    }

    @Test
    public void testSendMail() throws Exception {
        File file = new File(Environment.getDefault().getConfig(), "mail.properties");
        file.getParentFile().mkdirs();
        ArrayList<String> mailProperties = new ArrayList<String>();
        mailProperties.add(String.format("mail.smtp.host = %s", "badHostName"));
        mailProperties.add(String.format("mail.smtp.port = %s", "2525"));
        mailProperties.add(String.format("mail.smtp.connectiontimeout = %s", "1000"));
        mailProperties.add(String.format("mail.smtp.timeout = %s", "1000"));
        org.apache.commons.io.FileUtils.writeLines((File)file, mailProperties);
        HttpAutomationRequest operationRequest = this.session.newRequest("Document.Mail").setInput((Object)"doc:/").set("from", (Object)"sender@nuxeo.com").set("to", (Object)"recipient@nuxeo.com").set("subject", (Object)"My test mail").set("message", (Object)"The message content.");
        String error = operationRequest.executeReturningExceptionEntity(500);
        Assert.assertEquals((Object)"Failed to invoke operation: Document.Mail", (Object)error);
        JsonNode doc = operationRequest.set("rollbackOnError", (Object)"false").executeReturningDocument();
        Assert.assertEquals((Object)"/", (Object)this.getPath(doc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationAndAuthorizationErrors() throws Exception {
        String testUserName = "automation-test-user";
        NuxeoPrincipal principal = this.userManager.getPrincipal(testUserName);
        if (principal != null) {
            this.userManager.deleteUser(testUserName);
        }
        try {
            DocumentModel user = this.userManager.getBareUserModel();
            user.setPropertyValue("user:username", (Serializable)((Object)testUserName));
            user.setPropertyValue("user:password", (Serializable)((Object)"secret"));
            this.userManager.createUser(user);
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            try {
                this.client.getSession(testUserName, "badpassword");
                Assert.fail((String)"session should not have be created with bad password");
            }
            catch (AssertionError e) {
                Assert.assertEquals((Object)"expected:<200> but was:<401>", (Object)((Throwable)((Object)e)).getMessage());
            }
            HttpAutomationSession userSession = this.client.getSession(testUserName, "secret");
            String error = userSession.newRequest("Repository.GetDocument").set("value", (Object)"/").executeReturningExceptionEntity(403);
            Assert.assertEquals((Object)"Failed to invoke operation: Repository.GetDocument, Privilege 'Read' is not granted to 'automation-test-user'", (Object)error);
        }
        finally {
            this.userManager.deleteUser(testUserName);
        }
    }

    @Test
    public void sampleAutomationRemoteAccessWithComplexDocuments() throws Exception {
        this.setupComplexDocuments();
        JsonNode testDoc = this.session.newRequest("Document.GetChild").setInput((Object)"doc:/").set("name", (Object)"testDoc").executeReturningDocument();
        Assert.assertNotNull((Object)testDoc);
        Assert.assertEquals((Object)"testDoc", (Object)this.getTitle(testDoc));
        JsonNode properties = this.getProperties(testDoc);
        Assert.assertNull((Object)properties);
        testDoc = this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)"/testDoc").executeReturningDocument();
        Assert.assertNotNull((Object)testDoc);
        Assert.assertEquals((Object)"testDoc", (Object)this.getTitle(testDoc));
        properties = this.getProperties(testDoc);
        Assert.assertEquals((Object)"MyTable", (Object)properties.get("ds:tableName").asText());
        JsonNode dbFields = properties.get("ds:fields");
        Assert.assertNotNull((Object)dbFields);
        Assert.assertEquals((long)5L, (long)dbFields.size());
        JsonNode dbField0 = dbFields.get(0);
        Assert.assertNotNull((Object)dbField0);
        Assert.assertEquals((Object)"field0", (Object)dbField0.get("name").asText());
        Assert.assertEquals((Object)"Decision", (Object)dbField0.get("roles").get(0).asText());
        Assert.assertEquals((Object)"Score", (Object)dbField0.get("roles").get(1).asText());
        HashMap<String, String> updateProps = new HashMap<String, String>();
        updateProps.put("ds:tableName", "newTableName");
        updateProps.put("ds:attachments", "new1,new2,new3,new4");
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"updateFields.json");
        Assert.assertNotNull((Object)fieldAsJsonFile);
        String fieldsDataAsJSon = org.apache.commons.io.FileUtils.readFileToString((File)fieldAsJsonFile, (Charset)StandardCharsets.UTF_8);
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\n", "");
        fieldsDataAsJSon = fieldsDataAsJSon.replaceAll("\r", "");
        updateProps.put("ds:fields", fieldsDataAsJSon);
        testDoc = this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)testDoc).set("properties", updateProps).executeReturningDocument();
        Assert.assertEquals((Object)"testDoc", (Object)this.getTitle(testDoc));
        properties = this.getProperties(testDoc);
        Assert.assertEquals((Object)"newTableName", (Object)properties.get("ds:tableName").asText());
        JsonNode atts = properties.get("ds:attachments");
        Assert.assertNotNull((Object)atts);
        Assert.assertEquals((long)4L, (long)atts.size());
        Assert.assertEquals((Object)"new1", (Object)atts.get(0).asText());
        Assert.assertEquals((Object)"new4", (Object)atts.get(3).asText());
        dbFields = properties.get("ds:fields");
        Assert.assertEquals((long)2L, (long)dbFields.size());
        JsonNode dbFieldA = dbFields.get(0);
        Assert.assertNotNull((Object)dbFieldA);
        Assert.assertEquals((Object)"fieldA", (Object)dbFieldA.get("name").asText());
    }

    @Test
    public void testRawJSONDatastructuresAsParameters() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        POJOObject obj1 = new POJOObject("[obj1 text]", Arrays.asList("1", "2"));
        POJOObject obj2 = new POJOObject("[obj2 text]", Arrays.asList("2", "3"));
        String obj1JSON = mapper.writeValueAsString((Object)obj1);
        String obj2JSON = mapper.writeValueAsString((Object)obj2);
        Map map1 = (Map)mapper.readValue(obj1JSON, Map.class);
        Map map2 = (Map)mapper.readValue(obj2JSON, Map.class);
        POJOObject expectedObj12 = new POJOObject("Merged texts: [obj1 text][obj2 text]", Arrays.asList("1", "2", "2", "3"));
        POJOObject returnedObj12 = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").set("pojo", (Object)obj1).set("map", (Object)map2).executeReturningEntity(POJOObject.class);
        Assert.assertEquals((Object)expectedObj12, (Object)returnedObj12);
        returnedObj12 = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").set("pojo", (Object)map1).set("map", (Object)obj2).executeReturningEntity(POJOObject.class);
        Assert.assertEquals((Object)expectedObj12, (Object)returnedObj12);
        POJOObject expectedObj1AndDouble = new POJOObject("Merged texts: [obj1 text]", Arrays.asList("1", "2", "3.0"));
        POJOObject returnedObj1AndDouble = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").set("pojo", (Object)map1).set("doubleParam", (Object)3.0).executeReturningEntity(POJOObject.class);
        Assert.assertEquals((Object)expectedObj1AndDouble, (Object)returnedObj1AndDouble);
    }

    @Test
    public void testRawJSONDatastructuresAsInput() throws Exception {
        POJOObject expectedListObj = new POJOObject("Merged texts: ", Arrays.asList("a", "b", "c"));
        POJOObject returnedListObj = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").setInput(Arrays.asList("a", "b", "c")).executeReturningEntity(POJOObject.class);
        Assert.assertEquals((Object)expectedListObj, (Object)returnedListObj);
        POJOObject pojoInput = new POJOObject("input pojo", Arrays.asList("a", "b", "c"));
        returnedListObj = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").setInput((Object)pojoInput).executeReturningEntity(POJOObject.class);
        Assert.assertEquals((Object)expectedListObj, (Object)returnedListObj);
        ObjectMapper mapper = new ObjectMapper();
        Map mapInput = (Map)mapper.convertValue((Object)pojoInput, Map.class);
        returnedListObj = (POJOObject)this.session.newRequest("Operation.NestedJSONOperation").setInput((Object)mapInput).executeReturningEntity(POJOObject.class);
        Assert.assertEquals((Object)expectedListObj, (Object)returnedListObj);
    }

    @Test
    public void testArraysAsParametersAndResult() throws Exception {
        ArrayList<JSONOperationWithArrays.SimplePojo> list = new ArrayList<JSONOperationWithArrays.SimplePojo>();
        list.add(new JSONOperationWithArrays.SimplePojo("test1"));
        list.add(new JSONOperationWithArrays.SimplePojo("test2"));
        list.add(new JSONOperationWithArrays.SimplePojo("test3"));
        ArrayList<ArrayList<JSONOperationWithArrays.SimplePojo>> listList = new ArrayList<ArrayList<JSONOperationWithArrays.SimplePojo>>();
        listList.add(list);
        JSONOperationWithArrays.SimplePojo[] simplePojos = list.toArray(new JSONOperationWithArrays.SimplePojo[list.size()]);
        String type = "simplePojo";
        JSONOperationWithArrays.SimplePojo result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojoList", list, JSONOperationWithArrays.SimplePojo.class, type).set("whichPojo", (Object)"pojoList").executeReturningEntity(JSONOperationWithArrays.SimplePojo.class, type);
        Assert.assertEquals((Object)result1.getName(), (Object)"test1");
        result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojo", (Object)new JSONOperationWithArrays.SimplePojo("nico"), JSONOperationWithArrays.SimplePojo.class, type).set("whichPojo", (Object)"pojo").executeReturningEntity(JSONOperationWithArrays.SimplePojo.class, type);
        Assert.assertEquals((Object)result1.getName(), (Object)"nico");
        result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojoListList", listList, JSONOperationWithArrays.SimplePojo.class, type).set("whichPojo", (Object)"pojoListList").executeReturningEntity(JSONOperationWithArrays.SimplePojo.class, type);
        Assert.assertEquals((Object)result1.getName(), (Object)"test1");
        result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojoArray", (Object)simplePojos, JSONOperationWithArrays.SimplePojo.class, type).set("whichPojo", (Object)"pojoArray").executeReturningEntity(JSONOperationWithArrays.SimplePojo.class, type);
        Assert.assertEquals((Object)result1.getName(), (Object)"test1");
        result1 = (JSONOperationWithArrays.SimplePojo)this.session.newRequest("Operation.JSONOperationWithArrays").set("pojoArray", (Object)new JSONOperationWithArrays.SimplePojo[0], JSONOperationWithArrays.SimplePojo.class, type).set("whichPojo", (Object)"empty").executeReturningEntity(JSONOperationWithArrays.SimplePojo.class, type);
        Assert.assertNull((Object)result1);
    }

    @Test
    public void testNumericalValuesAsInputAndOuput() throws Exception {
        Number n = this.session.newRequest("Operation.NestedJSONOperation").setInput((Object)4.3).executeReturningNumberEntity();
        Assert.assertEquals((long)4L, (long)n.intValue());
    }

    @Test
    public void testAutomationBusinessObjects() throws Exception {
        BusinessBean note = new BusinessBean("Note", "File description", "Note Content", "Note", "object");
        String type = BusinessBeanAdapter.class.getSimpleName();
        note = (BusinessBean)this.session.newRequest("Business.BusinessCreateOperation").setInput((Object)note, BusinessBean.class, type).set("name", (Object)note.getTitle()).set("parentPath", (Object)"/").executeReturningEntity(BusinessBean.class, type);
        Assert.assertNotNull((Object)note);
        note = (BusinessBean)this.session.newRequest("Business.BusinessFetchOperation").setInput((Object)note, BusinessBean.class, type).executeReturningEntity(BusinessBean.class, type);
        Assert.assertNotNull((Object)note.getId());
        note.setTitle("Update");
        note = (BusinessBean)this.session.newRequest("Business.BusinessUpdateOperation").setInput((Object)note, BusinessBean.class, type).executeReturningEntity(BusinessBean.class, type);
        Assert.assertEquals((Object)"Update", (Object)note.getTitle());
    }

    @Test
    public void logAndThenQueryNoMapping() throws Exception {
        this.session.newRequest("Audit.LogEvent").setInput((Object)"doc:/").set("event", (Object)"testing").execute();
        JsonNode node = this.session.newRequest("Audit.QueryWithPageProvider").set("providerName", (Object)"AUDIT_BROWSER").execute();
        int count = node.get("currentPageSize").asInt();
        JsonNode entries = node.get("entries");
        for (int i = 0; i < count; ++i) {
            Assert.assertEquals((Object)"logEntry", (Object)entries.get(i).get("entity-type").asText());
        }
    }

    @Test
    public void testAutomationBusinessObjectsArray() throws Exception {
        BusinessBean[] businessBeans = (BusinessBean[])this.session.newRequest("Business.TestBusinessArray").executeReturningEntity(BusinessBean[].class);
        Assert.assertNotNull((Object)businessBeans);
        Assert.assertEquals((long)2L, (long)businessBeans.length);
    }

    @Test
    public void testRemoteException() throws Exception {
        String error = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test").executeReturningExceptionEntity(404);
        Assert.assertEquals((Object)"Failed to invoke operation: Repository.GetDocument, /test", (Object)error);
    }

    @Test
    public void shouldReturnCustomHttpStatusWhenFailure() throws Exception {
        String error = this.session.newRequest("Test.HttpStatus").set("isFailing", (Object)true).executeReturningExceptionEntity(405);
        Assert.assertEquals((Object)"Failed to invoke operation: Test.HttpStatus", (Object)error);
    }

    @Test
    public void shouldWriteAutomationContextWithDocuments() throws IOException {
        JsonNode root = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").executeReturningDocument();
        this.session.newRequest("RunOperationOnList").setContextParameter("users", List.of(this.getDocRef(root))).set("isolate", (Object)"true").set("id", (Object)"TestContext").set("list", (Object)"users").set("item", (Object)"document").execute();
    }

    @Test
    public void shouldReadContentEnricher() throws IOException {
        JsonNode node = this.session.newRequest("Repository.GetDocument").setHeader("X-NXenrichers.document", "breadcrumb").set("value", (Object)"/").executeReturningDocument();
        JsonNode context = node.get("contextParameters");
        Assert.assertNotNull((Object)context);
        JsonNode breadcrumb = context.get("breadcrumb");
        Assert.assertNotNull((Object)breadcrumb);
        Assert.assertEquals((Object)"documents", (Object)breadcrumb.get("entity-type").asText());
    }

    @Test
    public void canSendCalendarParameters() throws IOException {
        this.canSendCalendarParameters("existingMembers");
    }

    @Test
    @Deploy(value={"org.nuxeo.ecm.automation.test.test:test-allow-virtual-user.xml"})
    public void canSendCalendarParametersIfUserNotFound() throws IOException {
        ConfigurationService configService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        Assert.assertTrue((boolean)((Boolean)configService.getBoolean("nuxeo.automation.allowVirtualUser").orElseThrow(AssertionError::new)));
        this.canSendCalendarParameters("nonExistentMembers");
    }

    @Test
    public void cannotSendCalendarParametersIfUserNotFound() throws IOException {
        this.cannotSendCalendarParameters("nonExistentMembers");
    }

    private void cannotSendCalendarParameters(String username) throws IOException {
        GregorianCalendar begin = new GregorianCalendar(2015, 5, 20, 12, 34, 56);
        GregorianCalendar end = new GregorianCalendar(2015, 6, 14, 12, 34, 56);
        String error = this.session.newRequest("Document.AddPermission").setInput((Object)"doc:/").set("username", (Object)username).set("permission", (Object)"Write").set("begin", (Object)begin).set("end", (Object)end).executeReturningExceptionEntity(400);
        String expectedMsg = String.format("Failed to invoke operation: Document.AddPermission, Failed to invoke operation Document.AddPermission with aliases [Document.AddACL], The following set of User or Group names do not exist: [%s]. Please provide valid ones.", username);
        Assert.assertEquals((Object)expectedMsg, (Object)error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canSendCalendarParameters(String username) throws IOException {
        DocumentModel testUser = this.userManager.getBareUserModel();
        testUser.setProperty("user", "username", (Object)username);
        testUser = this.userManager.createUser(testUser);
        Assert.assertNotNull((Object)testUser.getId());
        this.txFeature.nextTransaction();
        try {
            GregorianCalendar begin = new GregorianCalendar(2015, 5, 20, 12, 34, 56);
            GregorianCalendar end = new GregorianCalendar(2015, 6, 14, 12, 34, 56);
            this.session.newRequest("Document.AddPermission").setInput((Object)"doc:/").set("username", (Object)username).set("permission", (Object)"Write").set("begin", (Object)begin).set("end", (Object)end).execute();
        }
        finally {
            this.userManager.deleteUser(testUser.getId());
        }
    }

    @Test
    public void testContextInjection() throws IOException {
        JsonNode folder = this.session.newRequest("ContextInjectionOperation").setHeader("X-NXDocumentProperties", "*").setInput((Object)"doc:/").setContextParameter("description", null).setContextParameter("title", (Object)"hello").executeReturningDocument();
        JsonNode properties = this.getProperties(folder);
        Assert.assertEquals((Object)"hello", (Object)properties.get("dc:title").asText());
        Assert.assertTrue((boolean)properties.get("dc:description").isNull());
    }
}

