/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.nuxeo.ecm.automation.test.HttpAutomationSession;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;

public class HttpAutomationRequest {
    public static final String ASYNC_ADAPTER = "/@async";
    public static final String ENTITY_TYPE = "entity-type";
    public static final String ENTITY_TYPE_EXCEPTION = "exception";
    public static final String ENTITY_TYPE_LOGIN = "login";
    public static final String ENTITY_TYPE_DOCUMENTS = "documents";
    public static final String ENTITY_TYPE_DOCUMENT = "document";
    public static final String ENTITY_TYPE_BOOLEAN = "boolean";
    public static final String ENTITY_TYPE_STRING = "string";
    public static final String ENTITY_TYPE_NUMBER = "number";
    public static final String ENTITY_TYPE_DATE = "date";
    public static final String VALUE = "value";
    public static final String INPUT = "input";
    public static final String PARAMS = "params";
    public static final String CONTEXT = "context";
    protected static final Duration ASYNC_POLL_DELAY = Duration.ofSeconds(1L);
    protected static final Duration ASYNC_POLL_TIMEOUT = Duration.ofSeconds(30L);
    protected static final JsonFactory FACTORY = new JsonFactory();
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected final HttpAutomationSession session;
    protected final String operationId;
    protected final Map<String, Object> params;
    protected final Map<String, Object> context;
    protected final Map<String, String> headers;
    protected Object input;

    public HttpAutomationRequest(HttpAutomationSession session, String operationId) {
        this.session = session;
        this.operationId = operationId;
        this.params = new HashMap<String, Object>();
        this.context = new HashMap<String, Object>();
        this.headers = new HashMap<String, String>();
    }

    public HttpAutomationSession getSession() {
        return this.session;
    }

    public HttpAutomationRequest setInput(Object input, Class<?> klass, String type) {
        return this.setInput(this.toNuxeoEntity(input, klass, type));
    }

    public HttpAutomationRequest setInput(Object input) {
        this.input = input;
        return this;
    }

    public HttpAutomationRequest set(String key, Object value, Class<?> klass, String type) {
        return this.set(key, this.toNuxeoEntity(value, klass, type));
    }

    public HttpAutomationRequest set(String key, Object value) {
        if (value == null) {
            this.params.remove(key);
            return this;
        }
        if (value.getClass() == Date.class) {
            Date date = (Date)value;
            this.params.put(key, date.toInstant().toString());
        } else if (value instanceof Calendar) {
            Calendar cal = (Calendar)value;
            this.params.put(key, cal.toInstant().toString());
        } else {
            this.params.put(key, value);
        }
        return this;
    }

    public HttpAutomationRequest setContextParameter(String key, Object value) {
        this.context.put(key, value);
        return this;
    }

    public HttpAutomationRequest setHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Object toNuxeoEntity(Object object, Class<?> klass, String type) {
        if (object instanceof List) {
            List list = (List)object;
            return list.stream().map(o -> this.toNuxeoEntity(o, klass, type)).collect(Collectors.toList());
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            return Arrays.stream(array).map(o -> this.toNuxeoEntity(o, klass, type)).collect(Collectors.toList());
        }
        if (klass.isAssignableFrom(object.getClass())) {
            return Map.of(ENTITY_TYPE, type, VALUE, object);
        }
        throw new NuxeoException(object.getClass().getName() + " is not a " + klass.getName());
    }

    public static String getEntityType(JsonNode node) {
        if (node == null) {
            return null;
        }
        JsonNode entityTypeNode = node.get(ENTITY_TYPE);
        if (entityTypeNode == null) {
            return null;
        }
        return entityTypeNode.asText();
    }

    protected void setupAutomationRequest(AbstractHttpMessage request) {
        this.session.addAuthentication(request);
        request.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType() + ", */*");
        this.headers.forEach((arg_0, arg_1) -> ((AbstractHttpMessage)request).setHeader(arg_0, arg_1));
    }

    public String executeRaw() throws IOException {
        try {
            return this.executeRaw(200, request -> {
                try {
                    return request.getBodyEntity();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public String executeRaw(int expectedStatusCode, Function<HttpAutomationRequest, HttpEntity> entityProvider) throws IOException {
        HttpPost request = new HttpPost(this.session.baseURL + this.operationId);
        this.setupAutomationRequest((AbstractHttpMessage)request);
        request.setEntity(entityProvider.apply(this));
        try (CloseableHttpResponse response = this.session.client.execute((HttpUriRequest)request);){
            String string;
            block12: {
                InputStream stream = response.getEntity().getContent();
                try {
                    Assert.assertEquals((long)expectedStatusCode, (long)response.getStatusLine().getStatusCode());
                    string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return string;
        }
    }

    public JsonNode executeReturningDocument() throws IOException {
        JsonNode node = this.execute();
        Assert.assertEquals((Object)ENTITY_TYPE_DOCUMENT, (Object)HttpAutomationRequest.getEntityType(node));
        return node;
    }

    public List<JsonNode> executeReturningDocuments() throws IOException {
        JsonNode node = this.execute();
        Assert.assertEquals((Object)ENTITY_TYPE_DOCUMENTS, (Object)HttpAutomationRequest.getEntityType(node));
        JsonNode entries = node.get("entries");
        Assert.assertTrue((String)entries.getNodeType().toString(), (boolean)entries.isArray());
        return IteratorUtils.toList((Iterator)entries.iterator());
    }

    public boolean executeReturningBooleanEntity() throws IOException {
        JsonNode node = this.execute();
        Assert.assertEquals((Object)ENTITY_TYPE_BOOLEAN, (Object)HttpAutomationRequest.getEntityType(node));
        return node.get(VALUE).asBoolean();
    }

    public String executeReturningStringEntity() throws IOException {
        JsonNode node = this.execute();
        Assert.assertEquals((Object)ENTITY_TYPE_STRING, (Object)HttpAutomationRequest.getEntityType(node));
        return node.get(VALUE).asText();
    }

    public Number executeReturningNumberEntity() throws IOException {
        JsonNode node = this.execute();
        Assert.assertEquals((Object)ENTITY_TYPE_NUMBER, (Object)HttpAutomationRequest.getEntityType(node));
        return node.get(VALUE).numberValue();
    }

    public Instant executeReturningDateEntity() throws IOException {
        JsonNode node = this.execute();
        Assert.assertEquals((Object)ENTITY_TYPE_DATE, (Object)HttpAutomationRequest.getEntityType(node));
        return Instant.parse(node.get(VALUE).asText());
    }

    public <T> T executeReturningEntity(Class<T> klass) throws IOException {
        return this.executeReturningEntity(klass, null);
    }

    public <T> T executeReturningEntity(Class<T> klass, String type) throws IOException {
        JsonNode node = this.execute();
        if (node == null || node.isMissingNode()) {
            return null;
        }
        if (type == null) {
            type = klass.getName();
        }
        Assert.assertEquals((Object)type, (Object)HttpAutomationRequest.getEntityType(node));
        return (T)MAPPER.convertValue((Object)node.get(VALUE), klass);
    }

    public String executeReturningExceptionEntity(int expectedStatusCode) throws IOException {
        JsonNode node = this.execute(expectedStatusCode);
        if (node == null || node.isMissingNode()) {
            return null;
        }
        Assert.assertEquals((Object)ENTITY_TYPE_EXCEPTION, (Object)HttpAutomationRequest.getEntityType(node));
        return node.get("message").asText();
    }

    public <T> T executeReturning(Class<T> klass) throws IOException {
        JsonNode node = this.execute();
        return (T)MAPPER.convertValue((Object)node, klass);
    }

    public <T> T executeReturning(TypeReference<T> typeReference) throws IOException {
        JsonNode node = this.execute();
        return (T)MAPPER.convertValue((Object)node, typeReference);
    }

    public JsonNode execute() throws IOException {
        return this.execute(0);
    }

    public JsonNode execute(int expectedStatusCode) throws IOException {
        try {
            return this.execute(expectedStatusCode, stream -> {
                try {
                    return MAPPER.readTree(stream);
                }
                catch (MismatchedInputException | ConnectionClosedException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public Blob executeReturningBlob() throws IOException {
        try {
            return this.execute(response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    return null;
                }
                Assert.assertEquals((long)200L, (long)statusCode);
                try {
                    return this.getBlob((HttpResponse)response);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public List<Blob> executeReturningBlobs() throws IOException {
        try {
            return this.execute(response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    return null;
                }
                Assert.assertEquals((long)200L, (long)statusCode);
                try {
                    return this.getBlobs((HttpResponse)response);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    protected Blob getBlob(HttpResponse response) throws IOException {
        Blob blob;
        block8: {
            HttpEntity entity = response.getEntity();
            String mimeType = entity.getContentType() == null ? null : entity.getContentType().getValue();
            String encoding = entity.getContentEncoding() == null ? null : entity.getContentEncoding().getValue();
            String contentDisposition = HttpAutomationRequest.getHeader(response, "Content-Disposition");
            InputStream stream = entity.getContent();
            try {
                blob = this.getBlob(stream, mimeType, encoding, contentDisposition);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ConnectionClosedException e) {
                    return null;
                }
            }
            stream.close();
        }
        return blob;
    }

    protected static String getHeader(HttpResponse response, String name) {
        Header[] headers = response.getHeaders(name);
        if (headers == null || headers.length == 0) {
            return null;
        }
        return headers[0].getValue();
    }

    protected Blob getBlob(BodyPart part) throws IOException, MessagingException {
        String mimeType = part.getHeader("Content-Type")[0];
        String encoding = null;
        String contentDisposition = part.getHeader("Content-Disposition")[0];
        try (InputStream stream = part.getInputStream();){
            Blob blob = this.getBlob(stream, mimeType, encoding, contentDisposition);
            return blob;
        }
    }

    /*
     * Exception decompiling
     */
    protected List<Blob> getBlobs(HttpResponse response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Blob getBlob(InputStream stream, String mimeType, String encoding, String contentDisposition) throws IOException {
        String filename = null;
        int i = contentDisposition.indexOf("filename=");
        if (i != -1) {
            filename = contentDisposition.substring(i + 9).replaceAll("\"", "");
        }
        Blob blob = Blobs.createBlob((InputStream)stream, (String)mimeType, (String)encoding);
        blob.setFilename(filename);
        return blob;
    }

    protected <T> T execute(int expectedStatusCode, Function<InputStream, T> streamProcessor) throws IOException {
        try {
            return (T)this.execute(response -> {
                Object r;
                block10: {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (expectedStatusCode == 0 && statusCode == 204) {
                        return null;
                    }
                    Assert.assertEquals((long)(expectedStatusCode == 0 ? 200L : (long)expectedStatusCode), (long)statusCode);
                    if (statusCode == 204) {
                        return null;
                    }
                    InputStream stream = response.getEntity().getContent();
                    try {
                        r = streamProcessor.apply(stream);
                        if (stream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    stream.close();
                }
                return r;
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    protected <T> T execute(Function<CloseableHttpResponse, T> responseProcessor) throws IOException {
        String url = this.session.baseURL + this.operationId;
        if (this.session.async) {
            url = url + ASYNC_ADAPTER;
        }
        HttpPost request = new HttpPost(url);
        this.setupAutomationRequest((AbstractHttpMessage)request);
        request.setEntity(this.getBodyEntity());
        if (this.session.async) {
            return this.executeAsyncAndPoll(request, responseProcessor);
        }
        try (CloseableHttpResponse response = this.session.client.execute((HttpUriRequest)request);){
            T t = responseProcessor.apply(response);
            return t;
        }
    }

    protected <T> T executeAsyncAndPoll(HttpPost request, Function<CloseableHttpResponse, T> responseProcessor) throws IOException {
        String pollUrl;
        try (CloseableHttpResponse response = this.session.client.execute((HttpUriRequest)request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 202) {
                T t = responseProcessor.apply(response);
                return t;
            }
            pollUrl = HttpAutomationRequest.getHeader((HttpResponse)response, "Location");
            if (pollUrl == null) {
                throw new IOException("202 without Location header");
            }
        }
        HttpGet pollRequest = new HttpGet(pollUrl);
        this.session.addAuthentication((AbstractHttpMessage)pollRequest);
        long deadline = System.nanoTime() + ASYNC_POLL_TIMEOUT.toNanos();
        do {
            BasicHttpContext httpContext = new BasicHttpContext();
            try (CloseableHttpResponse response = this.session.client.execute((HttpUriRequest)pollRequest, (HttpContext)httpContext);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 400) {
                    T t = responseProcessor.apply(response);
                    return t;
                }
                RedirectLocations locations = (RedirectLocations)httpContext.getAttribute("http.protocol.redirect-locations");
                if (locations != null && !locations.isEmpty()) {
                    T t = responseProcessor.apply(response);
                    return t;
                }
            }
            try {
                Thread.sleep(ASYNC_POLL_DELAY.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new NuxeoException("interrupted", (Throwable)e);
            }
        } while (System.nanoTime() < deadline);
        throw new IOException("Polling timeout: " + pollUrl);
    }

    public HttpEntity getBodyEntity() throws IOException {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        if (!(this.input instanceof Blob) && !HttpAutomationRequest.isBlobList(this.input)) {
            if (this.isDocument(this.input)) {
                JsonNode doc = (JsonNode)this.input;
                jsonMap.put(INPUT, HttpAutomationRequest.documentToJsonValue(doc));
            } else if (this.isDocumentList(this.input)) {
                List docs = (List)this.input;
                jsonMap.put(INPUT, HttpAutomationRequest.documentsToJsonValue(docs));
            } else if (this.input instanceof Date) {
                String value = ((Date)this.input).toInstant().toString();
                HashMap<String, String> dateMap = new HashMap<String, String>();
                dateMap.put(ENTITY_TYPE, ENTITY_TYPE_DATE);
                dateMap.put(VALUE, value);
                jsonMap.put(INPUT, dateMap);
            } else if (this.input != null) {
                jsonMap.put(INPUT, this.input);
            }
        }
        jsonMap.put(PARAMS, this.params == null ? Map.of() : this.params);
        jsonMap.put(CONTEXT, this.context == null ? Map.of() : this.context);
        StringWriter writer = new StringWriter();
        try {
            MAPPER.writeValue((Writer)writer, jsonMap);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String json = writer.toString();
        if (this.input == null || jsonMap.containsKey(INPUT)) {
            return new StringEntity(json, ContentType.APPLICATION_JSON);
        }
        if (this.input instanceof Blob) {
            Blob blob = (Blob)this.input;
            return this.blobsToEntity(json, List.of(blob));
        }
        if (HttpAutomationRequest.isBlobList(this.input)) {
            List blobs = (List)this.input;
            return this.blobsToEntity(json, blobs);
        }
        throw new IllegalStateException(this.input.getClass().getName());
    }

    protected static boolean isBlobList(Object object) {
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.isEmpty()) {
            return false;
        }
        return list.get(0) instanceof Blob;
    }

    protected boolean isDocument(Object object) {
        if (!(object instanceof JsonNode)) {
            return false;
        }
        JsonNode node = (JsonNode)object;
        return ENTITY_TYPE_DOCUMENT.equals(HttpAutomationRequest.getEntityType(node));
    }

    protected boolean isDocumentList(Object object) {
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.isEmpty()) {
            return false;
        }
        return this.isDocument(list.get(0));
    }

    protected static Object documentToJsonValue(JsonNode doc) {
        return Map.of(ENTITY_TYPE, ENTITY_TYPE_DOCUMENT, "uid", doc.get("uid").asText());
    }

    protected static Object documentsToJsonValue(List<JsonNode> docs) {
        String ids = docs.stream().map(doc -> doc.get("uid").asText()).collect(Collectors.joining(","));
        return "docs:" + ids;
    }

    protected HttpEntity blobsToEntity(String json, List<Blob> blobs) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("json", json, ContentType.APPLICATION_JSON);
        for (Blob blob : blobs) {
            String filename = blob.getFilename();
            if (filename == null) {
                filename = "file.bin";
            }
            builder.addBinaryBody("content", (InputStream)new ByteArrayInputStream(blob.getByteArray()), ContentType.create((String)blob.getMimeType(), (String)blob.getEncoding()), filename);
        }
        return builder.build();
    }

    public String login(int expectedStatusCode) throws IOException {
        HttpPost request = new HttpPost(this.session.baseURL + ENTITY_TYPE_LOGIN);
        this.setupAutomationRequest((AbstractHttpMessage)request);
        try (CloseableHttpResponse response = this.session.client.execute((HttpUriRequest)request);){
            Assert.assertEquals((long)expectedStatusCode, (long)response.getStatusLine().getStatusCode());
            if (expectedStatusCode == 200) {
                try (InputStream stream = response.getEntity().getContent();){
                    JsonNode node = MAPPER.readTree(stream);
                    Assert.assertEquals((Object)ENTITY_TYPE_LOGIN, (Object)HttpAutomationRequest.getEntityType(node));
                    String string = node.get("username").asText();
                    return string;
                }
            }
            String string = null;
            return string;
        }
    }

    public Blob getFile(String url) throws IOException {
        HttpGet request = new HttpGet(url);
        this.session.addAuthentication((AbstractHttpMessage)request);
        try (CloseableHttpResponse response = this.session.client.execute((HttpUriRequest)request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 204) {
                Blob blob = null;
                return blob;
            }
            Assert.assertEquals((long)200L, (long)statusCode);
            Blob blob = this.getBlob((HttpResponse)response);
            return blob;
        }
    }
}

