/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.automation.scripting.internals.ScriptingOperationTypeImpl;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.DummyCreateDocument;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.ecm.automation.core.operations.document.CreateDocument;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.automation.test.AutomationServerFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={AutomationServerFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.test"}), @Deploy(value={"org.nuxeo.ecm.webengine.core"})})
public class TestOperationRegistration {
    @Inject
    AutomationService service;
    @Inject
    ObjectCodecService objectCodecService;

    @Test
    public void testRegistration() throws Exception {
        OperationType op = this.service.getOperation("Document.Create");
        Assert.assertEquals(CreateDocument.class, (Object)op.getType());
        try {
            this.service.putOperation(DummyCreateDocument.class);
        }
        catch (OperationException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("An operation is already bound to: Document.Create"));
        }
        op = this.service.getOperation("Document.Create");
        Assert.assertEquals(CreateDocument.class, (Object)op.getType());
        this.service.putOperation(DummyCreateDocument.class, true);
        try {
            op = this.service.getOperation("Document.Create");
        }
        catch (OperationException operationException) {
            // empty catch block
        }
        Assert.assertEquals(DummyCreateDocument.class, (Object)op.getType());
    }

    @Test
    @Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.test.test:operation-contrib.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test.test:chain-scripting-operation-contrib.xml"})})
    public void testContributingComponent() throws Exception {
        OperationType op = this.service.getOperation("Document.Save");
        Assert.assertEquals((Object)"service:org.nuxeo.ecm.core.automation.coreContrib", (Object)op.getContributingComponent());
        op = this.service.getOperation("testOp");
        Assert.assertTrue((boolean)(op instanceof OperationTypeImpl));
        Assert.assertEquals((Object)"service:org.nuxeo.automation.rest.test.operationContrib", (Object)op.getContributingComponent());
        op = this.service.getOperation("FileManager.ImportWithMetaData");
        Assert.assertTrue((boolean)(op instanceof ChainTypeImpl));
        Assert.assertEquals((Object)"service:org.nuxeo.ecm.core.automation.features.operations", (Object)op.getContributingComponent());
        op = this.service.getOperation("testChain");
        Assert.assertTrue((boolean)(op instanceof ChainTypeImpl));
        Assert.assertEquals((Object)"service:org.nuxeo.automation.rest.test.operationContrib", (Object)op.getContributingComponent());
        op = this.service.getOperation("testChain2");
        Assert.assertTrue((boolean)(op instanceof ChainTypeImpl));
        Assert.assertEquals((Object)"service:org.nuxeo.automation.rest.test.chainScriptingOperationContrib", (Object)op.getContributingComponent());
        op = this.service.getOperation("javascript.RemoteScriptWithDoc");
        Assert.assertTrue((boolean)(op instanceof ScriptingOperationTypeImpl));
        Assert.assertEquals((Object)"service:org.nuxeo.automation.rest.test.operationContrib", (Object)op.getContributingComponent());
    }
}

