/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.context;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.test.AutomationServerFeature;
import org.nuxeo.ecm.automation.test.repository.AutomationRepositoryInit;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.webengine.test.WebEngineFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.ServletContainerFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={WebEngineFeature.class, AutomationServerFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.platform.url.api"}), @Deploy(value={"org.nuxeo.ecm.platform.url.core"}), @Deploy(value={"org.nuxeo.ecm.platform.types.api"}), @Deploy(value={"org.nuxeo.ecm.platform.types.core"}), @Deploy(value={"org.nuxeo.ecm.automation.test.test:test-servletcontainer-contrib.xml"})})
@RepositoryConfig(init=AutomationRepositoryInit.class, cleanup=Granularity.METHOD)
public class TestHttpHelpers {
    @Inject
    CoreSession session;
    @Inject
    AutomationService automationService;
    @Inject
    protected ServletContainerFeature servletContainerFeature;
    protected OperationContext ctx;

    @Before
    public void createOperationContext() {
        this.ctx = new OperationContext(this.session);
    }

    @After
    public void closeOperationContext() {
        this.ctx.close();
    }

    protected String getBaseURL() {
        int port = this.servletContainerFeature.getPort();
        return "http://localhost:" + port;
    }

    @Test
    public void canUseHttpHelperGET() throws OperationException, IOException {
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("script", (CallSite)((Object)("Context.result = HTTP.call(\"Administrator\",\"Administrator\",\"GET\", \"" + this.getBaseURL() + "/dummy/string\");")));
        this.automationService.run(this.ctx, "RunScript", params);
        String result = ((Blob)this.ctx.get((Object)"result")).getString();
        Assert.assertEquals((Object)"dummy", (Object)result);
    }

    @Test
    public void canUseHttpHelperPOST() throws OperationException, IOException {
        String data = "dummy data";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", "application/json");
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        this.ctx.put("data", (Object)data);
        this.ctx.put("headers", headers);
        params.put("script", (CallSite)((Object)("Context.result = HTTP.call(\"Administrator\",\"Administrator\",\"POST\", \"" + this.getBaseURL() + "/dummy/post\", Context.data, Context.headers);")));
        this.automationService.run(this.ctx, "RunScript", params);
        String result = ((Blob)this.ctx.get((Object)"result")).getString();
        Assert.assertEquals((Object)"dummy data", (Object)result);
    }

    @Test
    public void canUseHttpHelperGETStringBlob() throws OperationException, IOException {
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("script", (CallSite)((Object)("Context.result = HTTP.call(\"Administrator\",\"Administrator\",\"GET\", \"" + this.getBaseURL() + "/dummy/stringblob\");")));
        this.automationService.run(this.ctx, "RunScript", params);
        String result = ((Blob)this.ctx.get((Object)"result")).getString();
        Assert.assertEquals((Object)"dummy string blob", (Object)result);
    }

    @Test
    public void canUseHttpHelperGETBlob() throws OperationException, IOException {
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("script", (CallSite)((Object)("Context.result = HTTP.call(\"Administrator\",\"Administrator\",\"GET\", \"" + this.getBaseURL() + "/dummy/blob\");")));
        this.automationService.run(this.ctx, "RunScript", params);
        Blob result = (Blob)this.ctx.get((Object)"result");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.getLength() > 0L ? 1 : 0) != 0);
    }
}

