/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuxeo.ecm.automation.test.HttpAutomationClient;
import org.nuxeo.ecm.automation.test.HttpAutomationRequest;
import org.nuxeo.ecm.automation.test.HttpAutomationSession;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractAutomationClientTest {
    public static final String VOID_OPERATION = "X-NXVoidOperation";
    public static final String DOCUMENT_PROPERTIES = "X-NXDocumentProperties";
    protected JsonNode automationTestFolder;
    @Inject
    HttpAutomationSession session;
    @Inject
    HttpAutomationClient client;

    public String getId(JsonNode node) {
        return node.get("uid").asText();
    }

    public String getTitle(JsonNode node) {
        return node.get("title").asText();
    }

    public String getDescription(JsonNode node) {
        return this.getProperties(node).get("dc:description").asText();
    }

    public String getPath(JsonNode node) {
        return node.get("path").asText();
    }

    public JsonNode getProperties(JsonNode node) {
        return node.get("properties");
    }

    public Object getDocRef(JsonNode node) {
        return Map.of("entity-type", "document", "uid", this.getId(node));
    }

    @Before
    public void setupTestFolder() throws IOException {
        JsonNode root = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").executeReturningDocument();
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)"/", (Object)this.getPath(root));
        this.automationTestFolder = this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"Folder").set("name", (Object)"automation-test-folder").executeReturningDocument();
        Assert.assertNotNull((Object)this.automationTestFolder);
    }

    @After
    public void tearDownTestFolder() throws IOException {
        this.session.newRequest("Document.Delete").setInput((Object)this.automationTestFolder).execute();
    }

    protected File newFile(String content) throws IOException {
        File file = Framework.createTempFile((String)"automation-test-\u00e9\u00e1\u00f2-", (String)".xml");
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
        return file;
    }

    @Test
    public void testRemoteErrorHandling() throws Exception {
        this.session.newRequest("JsonStack.ToggleDisplay").execute();
        try {
            JsonNode node = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/automation-test-folder/unexisting").execute(404);
            Assert.assertEquals((Object)"exception", (Object)node.get("entity-type").asText());
            String cause = node.get("exception").get("className").asText();
            Assert.assertEquals((Object)DocumentNotFoundException.class.getName(), (Object)cause);
        }
        finally {
            this.session.newRequest("JsonStack.ToggleDisplay").execute();
        }
    }

    @Test
    public void testErrorDueToInvalidJson() throws IOException {
        Function<HttpAutomationRequest, HttpEntity> entityCorruptor = request -> {
            try {
                Object body;
                try (InputStream stream = request.getBodyEntity().getContent();){
                    body = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                }
                body = "{ foo " + ((String)body).substring(1);
                return new StringEntity((String)body, ContentType.APPLICATION_JSON);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        String res = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").executeRaw(400, entityCorruptor);
        JsonNode node = new ObjectMapper().readTree(res);
        Assert.assertEquals((Object)"exception", (Object)HttpAutomationRequest.getEntityType((JsonNode)node));
        String message = node.get("message").asText();
        Assert.assertTrue((String)message, (boolean)message.contains("Unexpected character"));
    }

    @Test
    public void testGetCreateUpdateAndRemoveDocument() throws Exception {
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder").set("properties", (Object)"dc:title=My Folder").executeReturningDocument();
        Assert.assertNotNull((Object)folder);
        Assert.assertEquals((Object)"/automation-test-folder/myfolder", (Object)this.getPath(folder));
        Assert.assertEquals((Object)"My Folder", (Object)this.getTitle(folder));
        folder = this.session.newRequest("Document.Update").setHeader(DOCUMENT_PROPERTIES, "*").setInput((Object)folder).set("properties", (Object)"dc:title=My Folder2\ndc:description=test").executeReturningDocument();
        Assert.assertNotNull((Object)folder);
        Assert.assertEquals((Object)"/automation-test-folder/myfolder", (Object)this.getPath(folder));
        Assert.assertEquals((Object)"My Folder2", (Object)this.getTitle(folder));
        Assert.assertEquals((Object)"test", (Object)this.getDescription(folder));
        this.session.newRequest("Document.Delete").setInput((Object)folder).execute();
        JsonNode folder1 = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder").set("properties", (Object)"dc:title=My Folder").executeReturningDocument();
        this.session.newRequest("Document.Delete").setInput(List.of(folder1)).execute();
        String error = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/automation-test-folder/myfolder").executeReturningExceptionEntity(404);
        Assert.assertEquals((Object)"Failed to invoke operation: Repository.GetDocument, /automation-test-folder/myfolder", (Object)error);
    }

    @Test
    public void testUpdateDocuments() throws Exception {
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"docsInput").set("properties", (Object)"dc:title=Query Test").executeReturningDocument();
        JsonNode note1 = this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1").executeReturningDocument();
        JsonNode note2 = this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note2").set("properties", (Object)"dc:title=Note2").executeReturningDocument();
        List docs = this.session.newRequest("Document.Update").setHeader(DOCUMENT_PROPERTIES, "*").setInput(List.of(note1, note2)).set("properties", (Object)"dc:description=updated").executeReturningDocuments();
        Assert.assertEquals((long)2L, (long)docs.size());
        JsonNode doc = this.session.newRequest("Repository.GetDocument").setHeader(DOCUMENT_PROPERTIES, "*").set("value", (Object)this.getPath(note1)).executeReturningDocument();
        Assert.assertEquals((Object)"updated", (Object)this.getDescription(doc));
        doc = this.session.newRequest("Repository.GetDocument").setHeader(DOCUMENT_PROPERTIES, "*").set("value", (Object)this.getPath(note2)).executeReturningDocument();
        Assert.assertEquals((Object)"updated", (Object)this.getDescription(doc));
    }

    @Test
    public void testUpdateDocumentWithChangeToken() throws Exception {
        JsonNode doc = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1").executeReturningDocument();
        String changeToken = doc.get("changeToken").asText();
        Assert.assertNotNull((Object)changeToken);
        doc = this.session.newRequest("Document.Update").setHeader(DOCUMENT_PROPERTIES, "*").setInput((Object)doc).set("changeToken", (Object)changeToken).set("properties", (Object)"dc:title=Update 1").executeReturningDocument();
        Assert.assertEquals((Object)"Update 1", (Object)this.getTitle(doc));
        changeToken = doc.get("changeToken").asText();
        String[] parts = changeToken.split("-");
        String newChangeToken = Long.parseLong(parts[0]) - 1L + "-" + parts[1];
        doc = this.session.newRequest("Document.Update").setHeader(DOCUMENT_PROPERTIES, "*").setInput((Object)doc).set("changeToken", (Object)newChangeToken).set("properties", (Object)"dc:title=Update 2").executeReturningDocument();
        Assert.assertEquals((Object)"Update 2", (Object)this.getTitle(doc));
        String error = this.session.newRequest("Document.Update").setHeader(DOCUMENT_PROPERTIES, "*").setInput((Object)doc).set("changeToken", (Object)"9999-1234").set("properties", (Object)"dc:title=Update 3").executeReturningExceptionEntity(409);
        String expectedError = String.format("Failed to invoke operation: Document.Update, Failed to invoke operation Document.Update, %s, Invalid change token", this.getId(doc));
        Assert.assertEquals((Object)expectedError, (Object)error);
        doc = this.session.newRequest("Repository.GetDocument").set("value", (Object)this.getPath(doc)).execute();
        Assert.assertEquals((Object)"Update 2", (Object)this.getTitle(doc));
    }

    @Test
    public void testNullProperties() throws Exception {
        JsonNode note = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1").executeReturningDocument();
        note = this.session.newRequest("Repository.GetDocument").setHeader(DOCUMENT_PROPERTIES, "*").set("value", (Object)this.getPath(note)).executeReturningDocument();
        JsonNode props = this.getProperties(note);
        Assert.assertTrue((boolean)props.get("dc:source").isNull());
    }

    @Test
    public void testQuery() throws Exception {
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"queryTest").set("properties", (Object)"dc:title=Query Test").executeReturningDocument();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1").executeReturningDocument();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note2").set("properties", (Object)"dc:title=Note2").executeReturningDocument();
        List docs = this.session.newRequest("Repository.Query").set("query", (Object)"SELECT * FROM Note WHERE ecm:path STARTSWITH '/automation-test-folder/queryTest' ").executeReturningDocuments();
        Assert.assertEquals((long)2L, (long)docs.size());
        String title1 = this.getTitle((JsonNode)docs.get(0));
        String title2 = this.getTitle((JsonNode)docs.get(1));
        Assert.assertTrue((title1.equals("Note1") && title2.equals("Note2") || title1.equals("Note2") && title2.equals("Note1") ? 1 : 0) != 0);
        docs = this.session.newRequest("Document.GetChildren").setInput((Object)folder).executeReturningDocuments();
        Assert.assertEquals((long)2L, (long)docs.size());
        title1 = this.getTitle((JsonNode)docs.get(0));
        title2 = this.getTitle((JsonNode)docs.get(1));
        Assert.assertTrue((title1.equals("Note1") && title2.equals("Note2") || title1.equals("Note2") && title2.equals("Note1") ? 1 : 0) != 0);
    }

    @Test
    public void testQueryAndFetch() throws Exception {
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"queryTest").set("properties", (Object)"dc:title=Query Test").executeReturningDocument();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1\ndc:description=Desc1").executeReturningDocument();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note2").set("properties", (Object)"dc:title=Note2\ndc:description=Desc2").executeReturningDocument();
        JsonNode node = this.session.newRequest("Repository.ResultSetQuery").set("query", (Object)"SELECT dc:title, ecm:uuid, dc:description FROM Note WHERE ecm:path STARTSWITH '/automation-test-folder/queryTest' order by dc:title ").execute();
        Assert.assertEquals((Object)"recordSet", (Object)node.get("entity-type").asText());
        JsonNode entries = node.get("entries");
        List result = IteratorUtils.toList((Iterator)entries.iterator());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"Note1", (Object)((JsonNode)result.get(0)).get("dc:title").asText());
        Assert.assertEquals((Object)"Note2", (Object)((JsonNode)result.get(1)).get("dc:title").asText());
        Assert.assertEquals((Object)"Desc1", (Object)((JsonNode)result.get(0)).get("dc:description").asText());
        Assert.assertEquals((Object)"Desc2", (Object)((JsonNode)result.get(1)).get("dc:description").asText());
    }

    @Test
    public void testAttachAndGetFile() throws Exception {
        String filename = "test.xml";
        String mimeType = "text/xml";
        Blob fb = Blobs.createBlob((String)"<doc>mydoc</doc>", (String)mimeType, null, (String)filename);
        this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"File").set("name", (Object)"myfile").set("properties", (Object)"dc:title=My File").execute();
        JsonNode res = this.session.newRequest("Blob.Attach").setHeader(VOID_OPERATION, "true").setInput((Object)fb).set("document", (Object)"/automation-test-folder/myfile").execute();
        Assert.assertNull((Object)res);
        JsonNode doc = this.session.newRequest("Repository.GetDocument").setHeader(DOCUMENT_PROPERTIES, "*").set("value", (Object)"/automation-test-folder/myfile").execute();
        JsonNode map = doc.get("properties").get("file:content");
        Assert.assertEquals((Object)filename, (Object)map.get("name").asText());
        Assert.assertEquals((Object)mimeType, (Object)map.get("mime-type").asText());
        String url = map.get("data").asText();
        Blob blob = this.session.newRequest().getFile(url);
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)filename, (Object)blob.getFilename());
        Assert.assertEquals((Object)mimeType, (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (Charset)StandardCharsets.UTF_8));
        blob = this.session.newRequest("Document.GetBlob").setInput((Object)doc).set("xpath", (Object)"file:content").executeReturningBlob();
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)filename, (Object)blob.getFilename());
        Assert.assertEquals((Object)mimeType, (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
    }

    @Test
    @Ignore(value="NXP-22652")
    public void testGetBlobs() throws Exception {
        this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Note").set("name", (Object)"blobs").set("properties", (Object)"dc:title=Blobs Test").executeReturningDocument();
        Blob fb1 = Blobs.createBlob((String)"<doc>mydoc1</doc>", (String)"text/xml", null, (String)"doc1.xml");
        Blob fb2 = Blobs.createBlob((String)"<doc>mydoc2</doc>", (String)"text/xml", null, (String)"doc2.xml");
        Blob blob = this.session.newRequest("Blob.AttachOnDocument").setHeader(VOID_OPERATION, "true").setInput((Object)fb1).set("document", (Object)"/automation-test-folder/blobs").set("xpath", (Object)"files:files").executeReturningBlob();
        Assert.assertNull((Object)blob);
        blob = this.session.newRequest("Blob.AttachOnDocument").setHeader(VOID_OPERATION, "true").setInput((Object)fb2).set("document", (Object)"/automation-test-folder/blobs").set("xpath", (Object)"files:files").executeReturningBlob();
        Assert.assertNull((Object)blob);
        JsonNode note = this.session.newRequest("Repository.GetDocument").setHeader(DOCUMENT_PROPERTIES, "*").set("value", (Object)"/automation-test-folder/blobs").executeReturningDocument();
        JsonNode list = this.getProperties(note).get("files:files");
        Assert.assertEquals((long)2L, (long)list.size());
        JsonNode map = list.get(0).get("file");
        Assert.assertEquals((Object)"doc1.xml", (Object)map.get("name").asText());
        Assert.assertEquals((Object)"text/xml", (Object)map.get("mime-type").asText());
        String path = map.get("data").asText();
        blob = this.session.newRequest().getFile(path);
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)"doc1.xml", (Object)blob.getFilename());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc1</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
        map = list.get(1).get("file");
        Assert.assertEquals((Object)"doc2.xml", (Object)map.get("name").asText());
        Assert.assertEquals((Object)"text/xml", (Object)map.get("mime-type").asText());
        path = map.get("data").asText();
        blob = this.session.newRequest().getFile(path);
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)"doc2.xml", (Object)blob.getFilename());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc2</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
        List blobs = this.session.newRequest("Document.GetBlobsByProperty").setInput((Object)note).set("xpath", (Object)"files:files").executeReturningBlobs();
        Assert.assertNotNull((Object)blobs);
        Assert.assertEquals((long)2L, (long)blobs.size());
        blob = (Blob)blobs.get(0);
        Assert.assertEquals((Object)"doc1.xml", (Object)blob.getFilename());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc1</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
        blob = (Blob)blobs.get(1);
        Assert.assertEquals((Object)"doc2.xml", (Object)blob.getFilename());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc2</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
    }

    @Test
    public void testUploadBlobs() throws Exception {
        Blob blob1 = Blobs.createBlob((String)"<doc>mydoc1</doc>", (String)"text/xml", null, (String)"doc1.xml");
        Blob blob2 = Blobs.createBlob((String)"<doc>mydoc2</doc>", (String)"text/xml", null, (String)"doc2.xml");
        Blob zip = this.session.newRequest("Blob.CreateZip").set("filename", (Object)"test.zip").setInput(List.of(blob1, blob2)).executeReturningBlob();
        Assert.assertNotNull((Object)zip);
        try (ZipFile zf = new ZipFile(zip.getFile());){
            ZipEntry entry1 = zf.getEntry("doc1.xml");
            Assert.assertNotNull((Object)entry1);
            ZipEntry entry2 = zf.getEntry("doc2.xml");
            Assert.assertNotNull((Object)entry2);
        }
    }

    @Test
    public void queriesArePaginable() throws IOException {
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"docsInput").set("properties", (Object)"dc:title=Query Test").executeReturningDocument();
        JsonNode[] notes = new JsonNode[15];
        for (int i = 0; i < 14; ++i) {
            notes[i] = this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)("note" + i)).set("properties", (Object)("dc:title=Note" + i)).executeReturningDocument();
        }
        List docs = this.session.newRequest("Repository.Query").set("query", (Object)"SELECT * from Document WHERE ecm:path STARTSWITH '/automation-test-folder/'").executeReturningDocuments();
        JsonNode cursor = this.session.newRequest("Repository.Query").set("query", (Object)"SELECT * from Document WHERE ecm:path STARTSWITH '/automation-test-folder/'").set("pageSize", (Object)2).execute();
        int pageSize = cursor.get("pageSize").asInt();
        int pageCount = cursor.get("numberOfPages").asInt();
        int totalSize = cursor.get("resultsCount").asInt();
        Assert.assertEquals((long)2L, (long)cursor.get("entries").size());
        int size = docs.size();
        Assert.assertEquals((long)size, (long)totalSize);
        Assert.assertEquals((long)2L, (long)pageSize);
        Assert.assertEquals((long)(size / 2 + size % 2), (long)pageCount);
    }

    @Test
    public void testSetArrayProperty() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("dc:title", "My Test Folder");
        props.put("dc:description", "test");
        props.put("dc:subjects", "art,sciences,biology");
        JsonNode folder = this.session.newRequest("Document.Create").setHeader(DOCUMENT_PROPERTIES, "*").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder2").set("properties", props).executeReturningDocument();
        Assert.assertEquals((Object)"My Test Folder", (Object)this.getTitle(folder));
        Assert.assertEquals((Object)"test", (Object)this.getDescription(folder));
        JsonNode ar = this.getProperties(folder).get("dc:subjects");
        Assert.assertEquals((long)3L, (long)ar.size());
        Assert.assertEquals((Object)"art", (Object)ar.get(0).asText());
        Assert.assertEquals((Object)"sciences", (Object)ar.get(1).asText());
        Assert.assertEquals((Object)"biology", (Object)ar.get(2).asText());
    }

    @Test
    public void testBadAccess() throws Exception {
        String error = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/foo").executeReturningExceptionEntity(404);
        Assert.assertEquals((Object)"Failed to invoke operation: Repository.GetDocument, /foo", (Object)error);
    }

    @Test
    public void testLock() throws Exception {
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder").set("properties", (Object)"dc:title=My Folder").execute();
        JsonNode doc = this.session.newRequest("Repository.GetDocument").setHeader(DOCUMENT_PROPERTIES, "*").set("value", (Object)this.getPath(folder)).execute();
        Assert.assertNull((Object)doc.get("lockOwner"));
        this.session.newRequest("Document.Lock").setHeader(VOID_OPERATION, "*").setInput((Object)doc).execute();
        doc = this.session.newRequest("Repository.GetDocument").setHeader(DOCUMENT_PROPERTIES, "*").setHeader("X-NXfetch.document", "lock").set("value", (Object)this.getPath(doc)).execute();
        Assert.assertEquals((Object)"Administrator", (Object)doc.get("lockOwner").asText());
        Assert.assertNotNull((Object)doc.get("lockCreated"));
    }

    @Test
    public void testEncoding() throws Exception {
        String title = "\u00e9\u00e8\u00ea\u00eb\u00e0\u00e0\u00e4\u00ec\u00ee\u00ef\u00f9\u00fb\u00f9";
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder").set("properties", (Object)("dc:title=" + title)).executeReturningDocument();
        folder = this.session.newRequest("Repository.GetDocument").setHeader(DOCUMENT_PROPERTIES, "*").set("value", (Object)this.getPath(folder)).execute();
        Assert.assertEquals((Object)title, (Object)this.getTitle(folder));
    }

    @Test
    public void testGetEmptyBlobsList() throws Exception {
        JsonNode file = this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"File").set("name", (Object)"blobs").set("properties", (Object)"dc:title=Blobs Test").executeReturningDocument();
        JsonNode node = this.session.newRequest("Document.GetBlobsByProperty").setInput((Object)file).execute(204);
        Assert.assertNull((Object)node);
    }
}

