/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.core.test.TransactionalFeature;
import org.nuxeo.ecm.webengine.test.WebEngineFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Deploy(value={"org.nuxeo.ecm.automation.core", "org.nuxeo.ecm.automation.io", "org.nuxeo.ecm.automation.server", "org.nuxeo.ecm.automation.features", "org.nuxeo.ecm.platform.query.api"})
@Features(value={TransactionalFeature.class, WebEngineFeature.class})
public class EmbeddedAutomationServerFeature
extends SimpleFeature {
    protected static final int HTTP_CONNECTION_TIMEOUT = 60000;
    protected HttpAutomationClient client;
    protected Session session;

    public void afterRun(FeaturesRunner runner) throws Exception {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
            this.session = null;
        }
        super.afterRun(runner);
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        super.configure(runner, binder);
        binder.bind(HttpAutomationClient.class).toProvider((Provider)new Provider<HttpAutomationClient>(){

            public HttpAutomationClient get() {
                if (EmbeddedAutomationServerFeature.this.client == null) {
                    EmbeddedAutomationServerFeature.this.client = EmbeddedAutomationServerFeature.this.getHttpAutomationClient();
                }
                return EmbeddedAutomationServerFeature.this.client;
            }
        }).in(Scopes.SINGLETON);
        binder.bind(Session.class).toProvider((Provider)new Provider<Session>(){

            public Session get() {
                if (EmbeddedAutomationServerFeature.this.client == null) {
                    EmbeddedAutomationServerFeature.this.client = EmbeddedAutomationServerFeature.this.getHttpAutomationClient();
                }
                if (EmbeddedAutomationServerFeature.this.session == null) {
                    EmbeddedAutomationServerFeature.this.session = EmbeddedAutomationServerFeature.this.client.getSession("Administrator", "Administrator");
                }
                return EmbeddedAutomationServerFeature.this.session;
            }
        }).in(Scopes.SINGLETON);
    }

    protected HttpAutomationClient getHttpAutomationClient() {
        HttpAutomationClient client = new HttpAutomationClient("http://localhost:18080/automation", 60000);
        client.setSharedRegistryExpirationDelay(0L);
        return client;
    }
}

