/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.onedrive;

import java.util.Objects;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.onedrive.client.OneDriveFile;

public class OneDriveLiveConnectFile
extends AbstractLiveConnectFile {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private final long fileSize;
    private final String digest;

    public OneDriveLiveConnectFile(LiveConnectFileInfo info, OneDriveFile.Metadata file) {
        super(info);
        this.filename = Objects.requireNonNull(file.getName());
        this.fileSize = file.getSize();
        this.digest = Objects.requireNonNull(OneDriveLiveConnectFile.getDigest(file));
    }

    public String getFilename() {
        return this.filename;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getDigest() {
        return this.digest;
    }

    private static String getDigest(OneDriveFile.Metadata file) {
        return file.getSha1Hash() == null ? file.getETag() : file.getSha1Hash();
    }
}

