/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.localconf;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.localconf.SimpleConfiguration;

@Operation(id="LocalConfiguration.SetSimpleConfigurationParameterAsVar", category="Local Configuration", label="Set Context Variable From a Simple Configuration Parameter", description="Set a context variable that points to the value of the given parameter name in the SimpleConfiguration from the input Document. You must give a name for the variable.")
public class SetSimpleConfParamVar {
    public static final String ID = "LocalConfiguration.SetSimpleConfigurationParameterAsVar";
    @Context
    protected OperationContext ctx;
    @Context
    protected LocalConfigurationService localConfigurationService;
    @Param(name="name")
    protected String name;
    @Param(name="parameterName")
    protected String parameterName;
    @Param(name="defaultValue", required=false)
    protected String defaultValue;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        SimpleConfiguration simpleConfiguration = (SimpleConfiguration)this.localConfigurationService.getConfiguration(SimpleConfiguration.class, "SimpleConfiguration", doc);
        String value = simpleConfiguration.get(this.parameterName, this.defaultValue);
        this.ctx.put(this.name, (Object)value);
        return doc;
    }
}

