/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.handler;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.mobile.handler.MobileRequestHandler;

public class MobileWithCookieRequestHandler
extends MobileRequestHandler {
    private static final String COOKIE_NAME = "skipMobileRedirection";

    protected String getCookieName() {
        return COOKIE_NAME;
    }

    @Override
    public boolean isRequestRedirectedToApplication(HttpServletRequest request) {
        Boolean checkCookie = this.checkCookie(request);
        if (checkCookie != null) {
            return checkCookie;
        }
        return super.isRequestRedirectedToApplication(request);
    }

    @Override
    public boolean isRequestRedirectedToApplicationLoginForm(HttpServletRequest request) {
        Boolean checkCookie = this.checkCookie(request);
        if (checkCookie != null) {
            return checkCookie;
        }
        return super.isRequestRedirectedToApplicationLoginForm(request);
    }

    private Boolean checkCookie(HttpServletRequest request) {
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!COOKIE_NAME.equals(cookie.getName())) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

