/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.mobile.handler.RequestHandler;

public class MobileRequestHandler
implements RequestHandler {
    public static final String URL_SKIPPED_PATTERNS_PROP = "urlSkippedPatterns";
    private static final Log log = LogFactory.getLog(MobileRequestHandler.class);
    private static List<String> MOBILE_USER_AGENT_REGEXP = Arrays.asList("(.*)Mobile(.*)Safari(.*)", "(.*)AppleWebKit(.*)Mobile(.*)", "(.*)Android(.*)");
    private String[] urlPatterns;

    @Override
    public boolean isRequestRedirectedToApplication(HttpServletRequest request) {
        String queryString = request.getQueryString() != null ? "?" + request.getQueryString() : "";
        String urlRequest = request.getRequestURL() + queryString;
        if (this.urlPatterns != null) {
            for (String urlPattern : this.urlPatterns) {
                if (!urlRequest.matches(urlPattern)) continue;
                String msg = "Mobile Handler: URL redirection (%s) is skipped by configuration: %s";
                log.info((Object)String.format(msg, urlRequest, urlPattern));
                return false;
            }
        }
        return this.isRequestRedirectedToApplicationLoginForm(request);
    }

    @Override
    public boolean isRequestRedirectedToApplicationLoginForm(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        for (String pattern : MOBILE_USER_AGENT_REGEXP) {
            if (!userAgent.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RequestHandler init(Map<String, String> properties) {
        String urlSkippedPatterns = properties.get(URL_SKIPPED_PATTERNS_PROP);
        if (urlSkippedPatterns != null && !"".equals(urlSkippedPatterns)) {
            this.urlPatterns = urlSkippedPatterns.split("[|]");
        }
        return this;
    }
}

