/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.handler;

import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.mobile.handler.RequestHandler;
import org.nuxeo.ecm.platform.ui.web.auth.CachableUserIdentificationInfo;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class AnonymousRequestHandler
implements RequestHandler {
    private static final Log log = LogFactory.getLog(AnonymousRequestHandler.class);
    private UserManager um;

    @Override
    public boolean isRequestRedirectedToApplicationLoginForm(HttpServletRequest request) {
        return this.isRequestRedirectedToApplication(request);
    }

    @Override
    public boolean isRequestRedirectedToApplication(HttpServletRequest request) {
        String anonymousUsername;
        HttpServletRequest httpRequest = request;
        String username = this.getUsernameFromRequest(httpRequest);
        if (username == null) {
            log.debug((Object)"No principal found in session, request not selected");
            return false;
        }
        try {
            anonymousUsername = this.getAnonymousUsername();
        }
        catch (Exception e) {
            log.error((Object)"Can't fetch anonymous username", (Throwable)e);
            return false;
        }
        return anonymousUsername.equals(username);
    }

    protected String getUsernameFromRequest(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        String result = null;
        if (principal != null) {
            result = principal.getName();
        } else {
            Object att = request.getSession().getAttribute("org.nuxeo.ecm.login.identity");
            if (att == null || !(att instanceof CachableUserIdentificationInfo)) {
                log.debug((Object)"No identity found in session, Application not selected");
                return null;
            }
            principal = ((CachableUserIdentificationInfo)att).getPrincipal();
            result = principal.getName();
        }
        log.debug((Object)("username fetched in session: " + result));
        return result;
    }

    protected String getAnonymousUsername() throws Exception {
        if (this.um == null) {
            this.um = (UserManager)Framework.getService(UserManager.class);
        }
        return this.um.getAnonymousUserId();
    }

    @Override
    public RequestHandler init(Map<String, String> properties) {
        return this;
    }
}

