/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.application.definition;

import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/myApplication")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="MyApplication")
public class MyApplication
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(MyApplication.class);
    private PluggableAuthenticationService service;

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    private PluggableAuthenticationService getService() throws Exception {
        if (this.service == null && Framework.getRuntime() != null) {
            this.service = (PluggableAuthenticationService)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
            this.service.initPreFilters();
            if (this.service == null) {
                log.error((Object)"Unable to get Service org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
                throw new Exception("Can't initialize Nuxeo Pluggable Authentication Service");
            }
        }
        return this.service;
    }

    @GET
    @Path(value="login")
    public Object doLogin() {
        return this.getView("login");
    }

    @GET
    @Path(value="logout")
    public Object doLogout(@Context HttpServletResponse response) throws Exception {
        Cookie cookie = new Cookie("JSESSIONID", null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
        this.getService().invalidateSession((ServletRequest)this.request);
        String redirect = this.request.getParameter("requestedUrl");
        if (redirect != null) {
            log.debug((Object)("Logout done: Redirect to default URL: " + redirect));
        } else {
            redirect = this.getContext().getBasePath();
        }
        return this.redirect(redirect);
    }
}

