/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.junit.Assert;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.test.DefaultRepositoryInit;
import org.nuxeo.runtime.api.Framework;

public class ContentDiffRepositoryInit
extends DefaultRepositoryInit {
    public static String getLeftPlainTextDocPath() {
        return "/leftPlainTextDoc";
    }

    public static String getRightPlainTextDocPath() {
        return "/rightPlainTextDoc";
    }

    public static String getLeftHTMLDocPath() {
        return "/leftHTMLDoc";
    }

    public static String getRightHTMLDocPath() {
        return "/rightHTMLDoc";
    }

    public static String getLeftJSONDocPath() {
        return "/leftJSONDoc";
    }

    public static String getRightJSONDocPath() {
        return "/rightJSONDoc";
    }

    public static String getLeftOfficeDocPath() {
        return "/leftOfficeDoc";
    }

    public static String getRightOfficeDocPath() {
        return "/rightOfficeDoc";
    }

    public static String getLeftImageDocPath() {
        return "/leftImageDoc";
    }

    public static String getRightImageDocPath() {
        return "/rightImageDoc";
    }

    public void populate(CoreSession session) {
        this.createFileDoc(session, "leftPlainTextDoc", "Left plain text doc", "left_doc.txt", "text/plain");
        this.createFileDoc(session, "rightPlainTextDoc", "Right plain text doc", "right_doc.txt", "text/plain");
        this.createFileDoc(session, "leftHTMLDoc", "Left HTML doc", "left_doc.html", "text/html");
        this.createFileDoc(session, "rightHTMLDoc", "Right HTML doc", "right_doc.html", "text/html");
        this.createFileDoc(session, "leftJSONDoc", "Left JSON doc", "left_doc.json", "application/json");
        this.createFileDoc(session, "rightJSONDoc", "Right JSON doc", "right_doc.json", "application/json");
        this.createFileDoc(session, "leftOfficeDoc", "Left Office doc", "left_doc.odt", "application/vnd.oasis.opendocument.text");
        this.createFileDoc(session, "rightOfficeDoc", "Right Office doc", "right_doc.odt", "application/vnd.oasis.opendocument.text");
        this.createFileDoc(session, "leftImageDoc", "Left image doc", "left_doc.png", "image/png");
        this.createFileDoc(session, "rightImageDoc", "Right image doc", "right_doc.png", "image/png");
    }

    protected DocumentModel createFileDoc(CoreSession session, String id, String title, String filePath, String mimeType) {
        DocumentModel doc = session.createDocumentModel("/", id, "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        doc.setPropertyValue("file:content", (Serializable)this.getBlobFromPath(filePath, mimeType));
        return session.createDocument(doc);
    }

    protected Blob getBlobFromPath(String path, String mimeType) {
        Blob blob;
        block8: {
            InputStream in = Framework.getResourceLoader().getResourceAsStream(path);
            try {
                Assert.assertNotNull((String)path, (Object)in);
                Blob blob2 = Blobs.createBlob((InputStream)in, (String)mimeType);
                blob2.setFilename(path);
                blob = blob2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            in.close();
        }
        return blob;
    }
}

