/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConverterNotRegistered;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.platform.convert:OSGI-INF/convert-service-contrib.xml"}), @Deploy(value={"org.nuxeo.diff.content"})})
public class TestContentDiffConverters {
    @Inject
    protected ConversionService conversionService;

    @Test
    public void testContentDiffHTMLConverterInfiniteLoop() {
        Blob blob = Blobs.createBlob((String)"foo", (String)"foo/bar");
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        try {
            this.conversionService.convert("contentDiffHtmlConverter", (BlobHolder)bh, null);
            Assert.fail();
        }
        catch (ConverterNotRegistered e) {
            Assert.assertEquals((Object)"Converter for sourceMimeType = foo/bar, destinationMimeType = text/html is not registered", (Object)e.getMessage());
        }
    }

    @Test
    public void testContentDiffTextConverterInfiniteLoop() {
        Blob blob = Blobs.createBlob((String)"foo", (String)"foo/bar");
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        try {
            this.conversionService.convert("contentDiffTextConverter", (BlobHolder)bh, null);
            Assert.fail();
        }
        catch (ConverterNotRegistered e) {
            Assert.assertEquals((Object)"Converter for sourceMimeType = foo/bar, destinationMimeType = text/plain is not registered", (Object)e.getMessage());
        }
    }
}

